/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.proxy;

import com.linecorp.armeria.client.proxy.ProxyConfig;
import com.linecorp.armeria.client.proxy.ProxyType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import java.net.InetSocketAddress;
import java.util.Objects;

public final class Socks5ProxyConfig
extends ProxyConfig {
    private final InetSocketAddress proxyAddress;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    Socks5ProxyConfig(InetSocketAddress proxyAddress, @Nullable String username, @Nullable String password) {
        this.proxyAddress = proxyAddress;
        this.username = username;
        this.password = password;
    }

    @Override
    public InetSocketAddress proxyAddress() {
        return this.proxyAddress;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Nullable
    public String password() {
        return this.password;
    }

    @Override
    public ProxyType proxyType() {
        return ProxyType.SOCKS5;
    }

    @Override
    public ProxyConfig withProxyAddress(InetSocketAddress newProxyAddress) {
        return new Socks5ProxyConfig(newProxyAddress, this.username, this.password);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Socks5ProxyConfig that = (Socks5ProxyConfig)o;
        return this.proxyAddress.equals(that.proxyAddress) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password);
    }

    public int hashCode() {
        return Objects.hash(this.proxyAddress, this.username, this.password);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("proxyType", (Object)this.proxyType()).add("proxyAddress", this.proxyAddress()).add("username", this.username()).add("password", Socks5ProxyConfig.maskPassword(this.username(), this.password())).toString();
    }
}

