/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.common.stream.StreamDecoderOutput;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.internal.common.grpc.ForwardingDecompressor;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.InternalGrpcExceptionHandler;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.StatusAndMetadata;
import com.linecorp.armeria.internal.common.grpc.TransportStatusListener;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Objects;

public final class HttpStreamDeframer
extends ArmeriaMessageDeframer {
    private final RequestContext ctx;
    private final DecompressorRegistry decompressorRegistry;
    private final TransportStatusListener transportStatusListener;
    private final InternalGrpcExceptionHandler exceptionHandler;
    @Nullable
    private StreamMessage<DeframedMessage> deframedStreamMessage;
    private boolean server;
    private boolean trailersReceived;

    public HttpStreamDeframer(DecompressorRegistry decompressorRegistry, RequestContext ctx, TransportStatusListener transportStatusListener, InternalGrpcExceptionHandler exceptionHandler, int maxMessageLength, boolean grpcWebText, boolean server) {
        super(maxMessageLength, ctx.alloc(), grpcWebText);
        this.ctx = Objects.requireNonNull(ctx, "ctx");
        this.decompressorRegistry = Objects.requireNonNull(decompressorRegistry, "decompressorRegistry");
        this.transportStatusListener = Objects.requireNonNull(transportStatusListener, "transportStatusListener");
        this.exceptionHandler = exceptionHandler;
        this.server = server;
    }

    public void setDeframedStreamMessage(StreamMessage<DeframedMessage> deframedStreamMessage) {
        Objects.requireNonNull(deframedStreamMessage, "deframedStreamMessage");
        Preconditions.checkState((this.deframedStreamMessage == null ? 1 : 0) != 0, (Object)"deframedStreamMessage is already set");
        this.deframedStreamMessage = deframedStreamMessage;
    }

    public void processHeaders(HttpHeaders headers, StreamDecoderOutput<DeframedMessage> out) {
        String grpcEncoding;
        if (headers instanceof RequestHeaders) {
            return;
        }
        String statusText = headers.get((CharSequence)HttpHeaderNames.STATUS);
        if (statusText == null) {
            this.transportStatusListener.transportReportStatus(Status.INTERNAL.withDescription("Missing HTTP status code"));
            return;
        }
        HttpStatus status = HttpStatus.valueOf((String)statusText);
        if (!status.equals((Object)HttpStatus.OK)) {
            this.trailersReceived = true;
            this.transportStatusListener.transportReportStatus(GrpcStatus.httpStatusToGrpcStatus(status.code()));
            return;
        }
        String grpcStatus = headers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (grpcStatus != null) {
            assert (this.deframedStreamMessage != null);
            this.trailersReceived = true;
            GrpcStatus.reportStatusLater(headers, this.deframedStreamMessage, this.transportStatusListener);
        }
        if ((grpcEncoding = headers.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING)) != null) {
            Decompressor decompressor = this.decompressorRegistry.lookupDecompressor(grpcEncoding);
            if (decompressor == null) {
                this.transportStatusListener.transportReportStatus(Status.INTERNAL.withDescription("Can't find decompressor for " + grpcEncoding));
                return;
            }
            try {
                this.decompressor(ForwardingDecompressor.forGrpc(decompressor));
            }
            catch (Throwable t) {
                StatusAndMetadata statusAndMetadata = this.exceptionHandler.handle(this.ctx, t);
                this.transportStatusListener.transportReportStatus(statusAndMetadata.status(), statusAndMetadata.metadata());
                return;
            }
        }
        if (grpcStatus == null) {
            Metadata metadata = MetadataUtil.copyFromHeaders(headers);
            this.transportStatusListener.transportReportHeaders(metadata);
        }
    }

    public void processTrailers(HttpHeaders headers, StreamDecoderOutput<DeframedMessage> out) {
        String grpcStatus = headers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        if (grpcStatus != null) {
            assert (this.deframedStreamMessage != null);
            this.trailersReceived = true;
            GrpcStatus.reportStatusLater(headers, this.deframedStreamMessage, this.transportStatusListener);
        }
    }

    public void processOnError(Throwable cause) {
        StatusAndMetadata statusAndMetadata = this.exceptionHandler.handle(this.ctx, cause);
        this.transportStatusListener.transportReportStatus(statusAndMetadata.status(), statusAndMetadata.metadata());
    }

    public void processOnComplete(StreamDecoderInput in, StreamDecoderOutput<DeframedMessage> out) throws Exception {
        if (!this.server && !this.trailersReceived) {
            Status status = Status.INTERNAL.withDescription("Missing gRPC status code");
            this.transportStatusListener.transportReportStatus(status);
            throw status.asRuntimeException();
        }
    }

    public HttpStreamDeframer decompressor(@Nullable com.linecorp.armeria.common.grpc.protocol.Decompressor decompressor) {
        return (HttpStreamDeframer)super.decompressor(decompressor);
    }
}

