/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.telemetry.api;

import java.io.Closeable;

public abstract class HistogramMetrics {
    public Timer createTimer() {
        return new Timer(this);
    }

    public abstract void observe(double var1);

    public static class Timer
    implements Closeable {
        private final HistogramMetrics metrics;
        private final long startNanos;
        private double duration;

        public Timer(HistogramMetrics metrics) {
            this.metrics = metrics;
            this.startNanos = System.nanoTime();
        }

        public void finish() {
            long endNanos = System.nanoTime();
            this.duration = (double)(endNanos - this.startNanos) / 1.0E9;
            this.metrics.observe(this.duration);
        }

        @Override
        public void close() {
            this.finish();
        }
    }
}

