/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.status;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.status.BootingStatus;
import org.apache.skywalking.oap.server.core.status.ClusterStatus;
import org.apache.skywalking.oap.server.core.status.ServerStatusWatcher;
import org.apache.skywalking.oap.server.library.module.ApplicationConfiguration;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class ServerStatusService
implements Service {
    private final ModuleManager manager;
    private BootingStatus bootingStatus = new BootingStatus();
    private ClusterStatus clusterStatus = new ClusterStatus();
    private List<ServerStatusWatcher> statusWatchers = new CopyOnWriteArrayList<ServerStatusWatcher>();
    private List<ApplicationConfiguration.ModuleConfiguration> configurations;

    public void bootedNow(List<ApplicationConfiguration.ModuleConfiguration> configurations, long uptime) {
        this.bootingStatus.setBooted(true);
        this.bootingStatus.setUptime(uptime);
        ((MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("uptime", "oap server start up time", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)uptime / 1000.0);
        this.statusWatchers.forEach(watcher -> watcher.onServerBooted(this.bootingStatus));
        this.configurations = configurations;
    }

    public void rebalancedCluster(long rebalancedTime) {
        this.clusterStatus.setRebalancedTime(rebalancedTime);
        ((MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class)).createGauge("cluster_rebalanced_time", "oap cluster rebalanced time after scale", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE).setValue((double)rebalancedTime / 1000.0);
        this.statusWatchers.forEach(watcher -> watcher.onClusterRebalanced(this.clusterStatus));
    }

    public void registerWatcher(ServerStatusWatcher watcher) {
        this.statusWatchers.add(watcher);
    }

    public ConfigList dumpBootingConfigurations(String keywords4MaskingSecretsOfConfig) {
        ConfigList configList = new ConfigList();
        if (this.configurations == null || this.configurations.isEmpty()) {
            return configList;
        }
        String[] keywords = keywords4MaskingSecretsOfConfig.split(",");
        for (ApplicationConfiguration.ModuleConfiguration configuration : this.configurations) {
            String moduleName = configuration.getModuleName();
            if (configuration.getProviders().size() == 1) {
                configList.put(moduleName + ".provider", (String)configuration.getProviders().keySet().iterator().next());
            }
            configuration.getProviders().forEach((providerName, providerConfiguration) -> providerConfiguration.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
                for (String keyword : keywords) {
                    if (!key.toString().toLowerCase().contains(keyword.toLowerCase())) continue;
                    value = "******";
                }
                configList.put(moduleName + "." + providerName + "." + String.valueOf(key), value.toString());
            })));
        }
        return configList;
    }

    @Generated
    public ServerStatusService(ModuleManager manager) {
        this.manager = manager;
    }

    @Generated
    public BootingStatus getBootingStatus() {
        return this.bootingStatus;
    }

    @Generated
    public ClusterStatus getClusterStatus() {
        return this.clusterStatus;
    }

    public static class ConfigList
    extends HashMap<String, String> {
        @Override
        public String toString() {
            StringBuilder configList = new StringBuilder();
            for (Map.Entry entry : this.entrySet()) {
                configList.append((String)entry.getKey()).append("=").append((String)entry.getValue()).append("\n");
            }
            return configList.toString();
        }
    }
}

