/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.remote.client;

import io.grpc.ManagedChannel;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.core.remote.client.RemoteClient;
import org.apache.skywalking.oap.server.core.remote.data.StreamData;
import org.apache.skywalking.oap.server.core.worker.IWorkerInstanceGetter;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfRemoteClient
implements RemoteClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelfRemoteClient.class);
    private final Address address;
    private CounterMetrics remoteOutCounter;
    private CounterMetrics remoteOutErrorCounter;
    private final IWorkerInstanceGetter workerInstanceGetter;

    public SelfRemoteClient(ModuleDefineHolder moduleDefineHolder, Address address) {
        this.address = address;
        this.workerInstanceGetter = (IWorkerInstanceGetter)moduleDefineHolder.find("core").provider().getService(IWorkerInstanceGetter.class);
        this.remoteOutCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_out_count", "The number(client side) of inside remote inside aggregate rpc.", new MetricsTag.Keys(new String[]{"dest", "self"}), new MetricsTag.Values(new String[]{address.toString(), "Y"}));
        this.remoteOutErrorCounter = ((MetricsCreator)moduleDefineHolder.find("telemetry").provider().getService(MetricsCreator.class)).createCounter("remote_out_error_count", "The error number(client side) of inside remote inside aggregate rpc.", new MetricsTag.Keys(new String[]{"dest", "self"}), new MetricsTag.Values(new String[]{address.toString(), "Y"}));
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public void connect() {
    }

    @Override
    public void close() {
        throw new UnexpectedException("Self remote client invoked to close.");
    }

    @Override
    public void push(String nextWorkerName, StreamData streamData) {
        try {
            this.workerInstanceGetter.get(nextWorkerName).getWorker().in(streamData);
            this.remoteOutCounter.inc();
        }
        catch (Throwable t) {
            this.remoteOutErrorCounter.inc();
            log.error(t.getMessage(), t);
        }
    }

    @Override
    public ManagedChannel getChannel() {
        return null;
    }

    @Override
    public int compareTo(RemoteClient o) {
        return this.address.compareTo(o.getAddress());
    }
}

