/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.metrics;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.storage.type.StorageDataComplexObject;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public class IntList
implements StorageDataComplexObject<IntList> {
    private List<Integer> data;

    public IntList(int initialSize) {
        this.data = new ArrayList<Integer>(initialSize);
    }

    public IntList(String valueString) {
        this.toObject(valueString);
    }

    public int size() {
        return this.data.size();
    }

    public boolean include(int value) {
        return this.data.contains(value);
    }

    @Override
    public String toStorageData() {
        StringBuilder builder = new StringBuilder();
        this.data.forEach(element -> {
            if (builder.length() != 0) {
                builder.append("|");
            }
            builder.append(element);
        });
        return builder.toString();
    }

    @Override
    public void toObject(String data) {
        if (StringUtil.isBlank((String)data)) {
            this.data = new ArrayList<Integer>(3);
            return;
        }
        String[] elements = data.split("\\|");
        this.data = new ArrayList<Integer>(elements.length);
        for (String element : elements) {
            this.data.add(Integer.parseInt(element));
        }
    }

    @Override
    public void copyFrom(IntList source) {
        this.data.addAll(source.data);
    }

    public void add(int value) {
        this.data.add(value);
    }

    public int get(int idx) {
        return this.data.get(idx);
    }

    @Generated
    public String toString() {
        return "IntList(data=" + String.valueOf(this.data) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntList)) {
            return false;
        }
        IntList other = (IntList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Integer> this$data = this.data;
        List<Integer> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IntList;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Integer> $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }
}

