/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.log.analyzer.provider.log.listener;

import com.google.protobuf.Message;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.log.analyzer.dsl.Binding;
import org.apache.skywalking.oap.log.analyzer.dsl.DSL;
import org.apache.skywalking.oap.log.analyzer.provider.LALConfig;
import org.apache.skywalking.oap.log.analyzer.provider.LALConfigs;
import org.apache.skywalking.oap.log.analyzer.provider.LogAnalyzerModuleConfig;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListener;
import org.apache.skywalking.oap.log.analyzer.provider.log.listener.LogAnalysisListenerFactory;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogFilterListener
implements LogAnalysisListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogFilterListener.class);
    private final Collection<DSL> dsls;

    @Override
    public void build() {
        this.dsls.forEach(dsl -> {
            try {
                dsl.evaluate();
            }
            catch (Exception e) {
                log.warn("Failed to evaluate dsl: {}", dsl, (Object)e);
            }
        });
    }

    @Override
    public LogAnalysisListener parse(LogData.Builder logData, Message extraLog) {
        this.dsls.forEach(dsl -> dsl.bind(new Binding().log(logData.build()).extraLog(extraLog)));
        return this;
    }

    @Generated
    public LogFilterListener(Collection<DSL> dsls) {
        this.dsls = dsls;
    }

    public static class Factory
    implements LogAnalysisListenerFactory {
        private final Map<Layer, Map<String, DSL>> dsls = new HashMap<Layer, Map<String, DSL>>();

        public Factory(ModuleManager moduleManager, LogAnalyzerModuleConfig config) throws Exception {
            List configList = LALConfigs.load(config.getLalPath(), config.lalFiles()).stream().flatMap(it -> it.getRules().stream()).collect(Collectors.toList());
            for (LALConfig c : configList) {
                Layer layer = Layer.nameOf((String)c.getLayer());
                Map dsls = this.dsls.computeIfAbsent(layer, k -> new HashMap());
                if (dsls.put(c.getName(), DSL.of(moduleManager, config, c.getDsl())) == null) continue;
                throw new ModuleStartException("Layer " + layer.name() + " has already set " + c.getName() + " rule.");
            }
        }

        @Override
        public LogAnalysisListener create(Layer layer) {
            if (layer == null) {
                return null;
            }
            Map<String, DSL> dsl = this.dsls.get(layer);
            if (dsl == null) {
                return null;
            }
            return new LogFilterListener(dsl.values());
        }
    }
}

