/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler;

import com.google.protobuf.Message;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Bytes;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.module.KafkaFetcherConfig;
import org.apache.skywalking.oap.server.analyzer.agent.kafka.provider.handler.LogHandler;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.ProtoBufJsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLogHandler
extends LogHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonLogHandler.class);
    private final KafkaFetcherConfig config;

    public JsonLogHandler(ModuleManager moduleManager, KafkaFetcherConfig config) {
        super(moduleManager, config);
        this.config = config;
    }

    @Override
    public String getPlainTopic() {
        return this.config.getTopicNameOfJsonLogs();
    }

    @Override
    protected String getDataFormat() {
        return "json";
    }

    @Override
    protected LogData parseConsumerRecord(ConsumerRecord<String, Bytes> record) throws IOException {
        LogData.Builder logDataBuilder = LogData.newBuilder();
        ProtoBufJsonUtils.fromJSON((String)new String(((Bytes)record.value()).get(), StandardCharsets.UTF_8), (Message.Builder)logDataBuilder);
        return logDataBuilder.build();
    }
}

