/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature.internal.shared;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.FeatureOperations;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.feature.internal.shared.FeatureView;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.visitor.ListingPropertyVisitor;
import org.apache.sis.io.TableAppender;
import org.apache.sis.pending.geoapi.filter.Literal;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.pending.jdk.Record;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CorruptedObjectException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;

public final class FeatureProjection
extends Record
implements UnaryOperator<AbstractFeature> {
    public final DefaultFeatureType typeRequested;
    public final DefaultFeatureType typeWithDependencies;
    private final String[] propertiesToCopy;
    private final Expression<? super AbstractFeature, ?>[] expressions;
    private final boolean createInstance;

    private FeatureProjection(DefaultFeatureType typeRequested, DefaultFeatureType typeWithDependencies, String[] propertiesToCopy, Expression<? super AbstractFeature, ?>[] expressions, boolean createInstance) {
        this.typeRequested = typeRequested;
        this.typeWithDependencies = typeWithDependencies;
        this.propertiesToCopy = propertiesToCopy;
        this.expressions = expressions;
        this.createInstance = createInstance;
    }

    FeatureProjection(DefaultFeatureType typeRequested, DefaultFeatureType typeWithDependencies, List<FeatureProjectionBuilder.Item> projection) {
        this.createInstance = true;
        this.typeRequested = typeRequested;
        this.typeWithDependencies = typeWithDependencies;
        Object[] expressions = new Expression[projection.size()];
        Object[] propertiesToCopy = new String[expressions.length];
        int storedCount = 0;
        for (FeatureProjectionBuilder.Item item : projection) {
            Expression<? super AbstractFeature, ?> expression = item.attributeValueGetter();
            if (expression == null) continue;
            expressions[storedCount] = expression;
            propertiesToCopy[storedCount++] = item.getPreferredName();
        }
        this.propertiesToCopy = (String[])ArraysExt.resize((Object[])propertiesToCopy, (int)storedCount);
        this.expressions = (Expression[])ArraysExt.resize((Object[])expressions, (int)storedCount);
    }

    public FeatureProjection forPreexistingFeatureInstances(int[] remaining) {
        if (remaining.length == 0 && this.typeRequested == this.typeWithDependencies) {
            return null;
        }
        Expression[] filteredExpressions = new Expression[remaining.length];
        String[] filteredProperties = new String[remaining.length];
        for (int i = 0; i < remaining.length; ++i) {
            int index = remaining[i];
            filteredProperties[i] = this.propertiesToCopy[index];
            filteredExpressions[i] = this.expressions[index];
        }
        return new FeatureProjection(this.typeRequested, this.typeWithDependencies, filteredProperties, filteredExpressions, false);
    }

    public FeatureProjection replaceExpressions(BiFunction<String, Expression<? super AbstractFeature, ?>, Expression<? super AbstractFeature, ?>> mapper) {
        LinkedHashMap filtered = JDK19.newLinkedHashMap((int)this.expressions.length);
        for (int i = 0; i < this.expressions.length; ++i) {
            PropertyTypeBuilder[] property2 = this.propertiesToCopy[i];
            if (filtered.put(property2, mapper.apply((String)property2, this.expressions[i])) == null) continue;
            throw new CorruptedObjectException(Errors.format((short)37, (Object)property2));
        }
        FeatureTypeBuilder builder = new FeatureTypeBuilder(this.typeWithDependencies);
        for (PropertyTypeBuilder property3 : (PropertyTypeBuilder[])builder.properties().toArray(PropertyTypeBuilder[]::new)) {
            filtered.computeIfAbsent(property3.getName().toString(), name -> {
                AbstractIdentifiedType type = property3.build();
                Expression expression = FeatureOperations.expressionOf(type);
                if (!expression.equals(expression = (Expression)mapper.apply((String)name, expression))) {
                    property3.replaceBy(builder.addProperty(FeatureOperations.replace(type, expression)));
                    return expression;
                }
                return null;
            });
        }
        if (!this.createInstance) {
            Iterator it = filtered.entrySet().iterator();
            while (it.hasNext()) {
                PropertyTypeBuilder property4;
                String name2;
                Map.Entry entry = it.next();
                Expression expression = (Expression)entry.getValue();
                if (!(expression instanceof ValueReference) || !(name2 = ((ValueReference)expression).getXPath()).equals(entry.getKey()) || (property4 = builder.getProperty(name2)) == null) continue;
                property4.remove();
                it.remove();
            }
        }
        if (this.typeWithDependencies != this.typeRequested) {
            HashSet<String> unnecessary = new HashSet<String>(Features.getPropertyNames(this.typeWithDependencies));
            unnecessary.removeAll(Features.getPropertyNames(this.typeRequested));
            for (PropertyTypeBuilder property5 : builder.properties()) {
                AbstractIdentifiedType type = property5.build();
                if (!(type instanceof AbstractOperation)) continue;
                unnecessary.removeAll(((AbstractOperation)type).getDependencies());
            }
            for (String name3 : unnecessary) {
                PropertyTypeBuilder property3;
                property3 = builder.getProperty(name3);
                if (property3 == null || filtered.remove(name3) == null) continue;
                property3.remove();
            }
        }
        filtered.keySet().removeIf(name -> {
            PropertyTypeBuilder property = builder.getProperty((String)name);
            return property != null && property.build() instanceof AbstractOperation;
        });
        Expression[] filteredExpressions = (Expression[])filtered.values().toArray(Expression[]::new);
        Object[] filteredProperties = (String[])filtered.keySet().toArray(String[]::new);
        if (Arrays.equals(filteredProperties, this.propertiesToCopy)) {
            filteredProperties = this.propertiesToCopy;
        }
        DefaultFeatureType withDeps = builder.build();
        boolean modified = builder.setName(this.typeRequested.getName()).properties().removeIf(property -> !this.typeRequested.hasProperty(property.getName().toString()));
        DefaultFeatureType filteredType = builder.build();
        if (filteredType.equals(this.typeRequested)) {
            filteredType = this.typeRequested;
        }
        if (!modified) {
            withDeps = filteredType;
        } else if (withDeps.equals(this.typeWithDependencies)) {
            withDeps = this.typeWithDependencies;
        }
        FeatureProjection p = new FeatureProjection(filteredType, withDeps, (String[])filteredProperties, filteredExpressions, this.createInstance);
        if (this.equals(p)) {
            p = this;
        }
        return p;
    }

    public final boolean hasOperations() {
        for (Expression<AbstractFeature, ?> expression : this.expressions) {
            if (expression instanceof ValueReference || expression instanceof Literal) continue;
            return true;
        }
        return false;
    }

    public final List<String> propertiesToCopy() {
        return Containers.viewAsUnmodifiableList((Object[])this.propertiesToCopy);
    }

    public final Expression<? super AbstractFeature, ?> expression(int index) {
        return this.expressions[index];
    }

    public Optional<String> xpath(int index) {
        Expression<AbstractFeature, ?> expression = this.expressions[index];
        if (expression instanceof ValueReference) {
            return Optional.of(((ValueReference)expression).getXPath());
        }
        return Optional.empty();
    }

    public Set<String> requiredSourceProperties() {
        Set<String> references = null;
        for (Expression<? super AbstractFeature, ?> expression : this.expressions) {
            references = ListingPropertyVisitor.xpaths(expression, references);
        }
        return references != null ? references : Set.of();
    }

    @Override
    public AbstractFeature apply(AbstractFeature source) {
        AbstractFeature feature = this.createInstance ? this.typeWithDependencies.newInstance() : source;
        for (int i = 0; i < this.expressions.length; ++i) {
            feature.setPropertyValue(this.propertiesToCopy[i], this.expressions[i].apply(source));
        }
        if (this.typeRequested != this.typeWithDependencies) {
            feature = new FeatureView(this.typeRequested, feature);
        }
        return feature;
    }

    public String toString() {
        return Row.toString(this, this.propertiesToCopy);
    }

    public int hashCode() {
        return Objects.hash(this.typeRequested, this.typeWithDependencies, this.createInstance) + 97 * (Arrays.hashCode(this.propertiesToCopy) + 97 * Arrays.hashCode(this.expressions));
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeatureProjection) {
            FeatureProjection other = (FeatureProjection)obj;
            return this.createInstance == other.createInstance && this.typeRequested.equals(other.typeRequested) && this.typeWithDependencies.equals(other.typeWithDependencies) && Arrays.equals(this.propertiesToCopy, other.propertiesToCopy) && Arrays.equals(this.expressions, other.expressions);
        }
        return false;
    }

    private static final class Row {
        private final String property;
        private String xpath;
        private String type;

        static String toString(FeatureProjection projection, String[] propertiesToCopy) {
            LinkedHashMap<String, Row> rowByName = new LinkedHashMap<String, Row>();
            if (projection.typeWithDependencies != projection.typeRequested) {
                Row.addAll(rowByName, projection.typeWithDependencies, "dependency");
            }
            Row.addAll(rowByName, projection.typeRequested, "operation");
            for (int i = 0; i < propertiesToCopy.length; ++i) {
                String value;
                String name = propertiesToCopy[i];
                try {
                    name = projection.typeWithDependencies.getProperty(name).getName().toString();
                    value = "stored";
                }
                catch (RuntimeException e) {
                    value = e.toString();
                }
                Row row = rowByName.computeIfAbsent(name, Row::new);
                row.type = value;
                row.xpath = projection.xpath(i).orElse("");
            }
            Vocabulary words = Vocabulary.forLocale(null);
            TableAppender table = new TableAppender(" \u2502 ");
            table.setMultiLinesCells(true);
            table.appendHorizontalSeparator();
            table.append((CharSequence)words.getString((short)238)).nextColumn();
            table.append((CharSequence)words.getString((short)203)).nextColumn();
            table.append((CharSequence)"XPath").nextLine();
            table.appendHorizontalSeparator();
            for (Row row : rowByName.values()) {
                table.append((CharSequence)row.property).nextColumn();
                table.append((CharSequence)row.type).nextColumn();
                table.append((CharSequence)row.xpath).nextLine();
            }
            table.appendHorizontalSeparator();
            return table.toString();
        }

        private static void addAll(Map<String, Row> rowByName, DefaultFeatureType featureType, String type) {
            for (AbstractIdentifiedType property : featureType.getProperties(true)) {
                Row row = rowByName.computeIfAbsent(property.getName().toString(), Row::new);
                row.type = type;
            }
        }

        private Row(String name) {
            this.property = name;
            this.xpath = "";
        }
    }
}

