/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.style.se1;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Optional;
import org.apache.sis.filter.Expression;
import org.apache.sis.style.se1.Fill;
import org.apache.sis.style.se1.GraphicalSymbol;
import org.apache.sis.style.se1.Stroke;
import org.apache.sis.style.se1.StyleFactory;

@XmlType(name="MarkType", propOrder={"wellKnownName", "format", "markIndex", "fill", "stroke"})
@XmlRootElement(name="Mark")
public class Mark<R>
extends GraphicalSymbol<R> {
    @XmlElement(name="WellKnownName")
    protected Expression<R, String> wellKnownName;
    @XmlElement(name="Fill")
    protected Fill<R> fill;
    private boolean isFillSet;
    @XmlElement(name="Stroke")
    protected Stroke<R> stroke;
    private boolean isStrokeSet;
    @XmlElement(name="MarkIndex")
    protected Expression<R, Integer> markIndex;

    private void beforeMarshal(Marshaller caller) {
        if (this.fill == null && !this.isFillSet) {
            this.fill = this.factory.createFill();
        }
        if (this.stroke == null && !this.isStrokeSet) {
            this.stroke = this.factory.createStroke();
        }
    }

    private Mark() {
        this.isFillSet = true;
        this.isStrokeSet = true;
    }

    public Mark(StyleFactory<R> factory) {
        super(factory);
    }

    public Mark(Mark<R> source) {
        super(source);
        this.wellKnownName = source.wellKnownName;
        this.fill = source.fill;
        this.stroke = source.stroke;
    }

    public Expression<R, String> getWellKnownName() {
        Expression<R, String> value = this.wellKnownName;
        return value != null ? value : this.factory.square;
    }

    public void setWellKnownName(Expression<R, String> value) {
        this.wellKnownName = value;
    }

    public Optional<Fill<R>> getFill() {
        if (!this.isFillSet) {
            this.isFillSet = true;
            this.fill = this.factory.createFill();
        }
        return Optional.ofNullable(this.fill);
    }

    public void setFill(Fill<R> value) {
        this.isFillSet = true;
        this.fill = value;
    }

    public Optional<Stroke<R>> getStroke() {
        if (!this.isStrokeSet) {
            this.isStrokeSet = true;
            this.stroke = this.factory.createStroke();
        }
        return Optional.ofNullable(this.stroke);
    }

    public void setStroke(Stroke<R> value) {
        this.isStrokeSet = true;
        this.stroke = value;
    }

    public Optional<Expression<R, Integer>> getMarkIndex() {
        return Optional.ofNullable(this.markIndex);
    }

    public void setMarkIndex(Expression<R, Integer> value) {
        this.markIndex = value;
    }

    @Override
    final Object[] properties() {
        return new Object[]{this.wellKnownName, this.fill, this.isFillSet, this.stroke, this.isStrokeSet, this.markIndex};
    }

    @Override
    public Mark<R> clone() {
        Mark clone = (Mark)super.clone();
        clone.selfClone();
        return clone;
    }

    private void selfClone() {
        if (this.fill != null) {
            this.fill = this.fill.clone();
        }
        if (this.stroke != null) {
            this.stroke = this.stroke.clone();
        }
    }
}

