/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import jakarta.xml.bind.annotation.XmlValue;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.shared.AbstractMapEntry;
import org.apache.sis.util.internal.shared.Strings;
import org.apache.sis.util.iso.DefaultRecordType;
import org.apache.sis.util.iso.RecordDefinition;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.MemberName;
import org.opengis.util.Record;
import org.opengis.util.RecordType;

public class DefaultRecord
implements Record,
Serializable {
    private static final long serialVersionUID = -5293250754663538325L;
    final RecordDefinition definition;
    private Object values;

    public DefaultRecord(RecordType type) {
        this.definition = Objects.requireNonNull(type) instanceof RecordDefinition ? (RecordDefinition)type : new RecordDefinition.Adapter(type);
        this.values = Array.newInstance(this.definition.baseValueClass(), this.definition.size());
    }

    public DefaultRecord(Record record) {
        this(record.getRecordType());
        if (record instanceof DefaultRecord) {
            Object source = ((DefaultRecord)record).values;
            System.arraycopy(source, 0, this.values, 0, Array.getLength(source));
        } else {
            for (Map.Entry<MemberName, Integer> entry : this.definition.fieldIndices().entrySet()) {
                MemberName name = entry.getKey();
                Object value = record.locate(name);
                if (value == null) continue;
                int index = entry.getValue();
                Class<?> valueClass = this.definition.getValueClass(index);
                if (valueClass != null && !valueClass.isInstance(value)) {
                    throw new ClassCastException(Errors.format((short)74, (Object)name, valueClass, value.getClass()));
                }
                Array.set(this.values, index, value);
            }
        }
    }

    public static DefaultRecord castOrCopy(Record other) {
        if (other == null || other instanceof DefaultRecord) {
            return (DefaultRecord)other;
        }
        return new DefaultRecord(other);
    }

    public RecordType getRecordType() {
        return this.definition.getRecordType();
    }

    @Deprecated
    public Map<MemberName, Object> getAttributes() {
        return this.getFields();
    }

    public Map<MemberName, Object> getFields() {
        if (this.values == null) {
            return Map.of();
        }
        return new AbstractMap<MemberName, Object>(){

            @Override
            public int size() {
                return DefaultRecord.this.definition.size();
            }

            @Override
            public Object get(Object name) {
                return name instanceof MemberName ? DefaultRecord.this.locate((MemberName)name) : null;
            }

            @Override
            public Object put(MemberName name, Object value) {
                Object previous = DefaultRecord.this.locate(name);
                DefaultRecord.this.set(name, value);
                return previous;
            }

            @Override
            public Set<Map.Entry<MemberName, Object>> entrySet() {
                return new Entries();
            }
        };
    }

    public Object locate(MemberName name) {
        Integer index = this.definition.indexOf(name);
        return index != null ? Array.get(this.values, index) : null;
    }

    public void set(MemberName name, Object value) {
        Class<?> valueClass;
        Integer index = this.definition.indexOf(name);
        if (index == null) {
            throw new IllegalArgumentException(Errors.format((short)149, (Object)this.getRecordType().getTypeName(), (Object)name));
        }
        if (value != null && (valueClass = this.definition.getValueClass(index)) != null && !valueClass.isInstance(value)) {
            throw new ClassCastException(Errors.format((short)74, (Object)name, valueClass, value.getClass()));
        }
        Array.set(this.values, index, value);
    }

    public void setAll(Object ... newValues) {
        int length = Array.getLength(this.values);
        if (newValues.length != length) {
            throw new IllegalArgumentException(Errors.format((short)164, (Object)length, (Object)newValues.length));
        }
        for (int i = 0; i < newValues.length; ++i) {
            Class<?> valueClass;
            Object value = newValues[i];
            if (value != null && (valueClass = this.definition.getValueClass(i)) != null && !valueClass.isInstance(value)) {
                throw new ClassCastException(Errors.format((short)74, (Object)this.definition.getName(i), valueClass, value.getClass()));
            }
            Array.set(this.values, i, value);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            DefaultRecord that = (DefaultRecord)object;
            return this.definition.getRecordType().equals((Object)that.definition.getRecordType()) && Objects.deepEquals(this.values, that.values);
        }
        return false;
    }

    public int hashCode() {
        return Utilities.deepHashCode((Object)this.values) ^ this.definition.getRecordType().hashCode();
    }

    public String toString() {
        return this.definition.toString("Record", this.values);
    }

    private DefaultRecord() {
        this.definition = DefaultRecordType.SINGLE_STRING;
    }

    @XmlValue
    private String getValue() {
        if (this.values != null) {
            switch (Array.getLength(this.values)) {
                case 0: {
                    break;
                }
                case 1: {
                    return String.valueOf(Array.get(this.values, 0));
                }
                default: {
                    return this.definition.toString(null, this.values);
                }
            }
        }
        return null;
    }

    private void setValue(String value) {
        if ((value = Strings.trimOrNull((String)value)) != null) {
            this.values = new String[]{value};
        }
    }

    private final class Entry
    extends AbstractMapEntry<MemberName, Object> {
        private final int index;

        Entry(int index) {
            this.index = index;
        }

        public MemberName getKey() {
            return DefaultRecord.this.definition.getName(this.index);
        }

        public Object getValue() {
            return DefaultRecord.this.locate(this.getKey());
        }

        public Object setValue(Object value) {
            MemberName name = this.getKey();
            Object previous = DefaultRecord.this.locate(name);
            DefaultRecord.this.set(name, value);
            return previous;
        }
    }

    private final class Iter
    implements Iterator<Map.Entry<MemberName, Object>> {
        private int index;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.index < DefaultRecord.this.definition.size();
        }

        @Override
        public Map.Entry<MemberName, Object> next() {
            if (this.hasNext()) {
                return new Entry(this.index++);
            }
            throw new NoSuchElementException();
        }
    }

    private final class Entries
    extends AbstractSet<Map.Entry<MemberName, Object>> {
        private Entries() {
        }

        @Override
        public int size() {
            return DefaultRecord.this.definition.size();
        }

        @Override
        public Iterator<Map.Entry<MemberName, Object>> iterator() {
            return new Iter();
        }
    }
}

