/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.sql.feature.Analyzer;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.Database;
import org.apache.sis.storage.sql.feature.FeatureAnalyzer;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.feature.Relation;
import org.apache.sis.storage.sql.feature.SchemaModifier;
import org.apache.sis.storage.sql.feature.TableReference;
import org.apache.sis.util.internal.shared.Strings;

final class TableAnalyzer
extends FeatureAnalyzer {
    private final TableReference dependencyOf;
    private final String tableEsc;
    private final String schemaEsc;
    private final boolean isSearchReliable;

    TableAnalyzer(Analyzer analyzer, TableReference id, TableReference dependencyOf) throws SQLException {
        super(analyzer, id);
        this.dependencyOf = dependencyOf;
        this.tableEsc = analyzer.database.escapeWildcards(id.table);
        this.schemaEsc = analyzer.database.escapeWildcards(id.schema);
        this.isSearchReliable = analyzer.database.canEscapeWildcards() || this.tableEsc == id.table && this.schemaEsc == id.schema;
        try (ResultSet reflect = analyzer.metadata.getPrimaryKeys(id.catalog, id.schema, id.table);){
            while (reflect.next()) {
                this.primaryKey.add(analyzer.getUniqueString(reflect, "COLUMN_NAME"));
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            analyzer.unavailableMetadata(e);
        }
    }

    private boolean filterMetadata(ResultSet reflect) throws SQLException {
        return this.isSearchReliable || Database.filterMetadata(reflect, this.id.schema, this.id.table, null);
    }

    @Override
    final Relation[] getForeignerKeys(Relation.Direction direction) throws SQLException, DataStoreException {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        boolean isImport = direction == Relation.Direction.IMPORT;
        try (ResultSet reflect = isImport ? this.analyzer.metadata.getImportedKeys(this.id.catalog, this.id.schema, this.id.table) : this.analyzer.metadata.getExportedKeys(this.id.catalog, this.id.schema, this.id.table);){
            if (reflect.next()) {
                do {
                    Relation relation;
                    if ((relation = new Relation(this.analyzer, direction, reflect)).equals(this.dependencyOf)) {
                        if (!isImport) continue;
                        SchemaModifier customizer = this.analyzer.customizer;
                        boolean bl = relation.excluded = customizer == null || !customizer.isCyclicAssociationAllowed(this.id);
                    }
                    if (isImport) {
                        this.addForeignerKeys(relation);
                    } else if (relation.excluded) continue;
                    relations.add(relation);
                } while (!reflect.isClosed());
            }
        }
        catch (SQLFeatureNotSupportedException e) {
            this.analyzer.unavailableMetadata(e);
        }
        int size = relations.size();
        return size != 0 ? relations.toArray(new Relation[size]) : Relation.EMPTY;
    }

    @Override
    final Column[] createAttributes() throws Exception {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        String quote = this.analyzer.metadata.getIdentifierQuoteString();
        try (ResultSet reflect = this.analyzer.metadata.getColumns(this.id.catalog, this.schemaEsc, this.tableEsc, null);){
            while (reflect.next()) {
                Object column;
                if (!this.filterMetadata(reflect) || columns.put(((Column)column).name, (Column)(column = new Column(this.analyzer, reflect, quote))) == null) continue;
                throw this.duplicatedColumn((Column)column);
            }
        }
        InfoStatements spatialInformation = this.analyzer.spatialInformation;
        if (spatialInformation != null) {
            spatialInformation.completeIntrospection(this.analyzer, this.id, columns);
        }
        if (spatialInformation == null || spatialInformation.geometryColumns == null) {
            for (Column column : columns.values()) {
                column.tryMakeSpatial(this.analyzer);
            }
        }
        ArrayList<Column> attributes = new ArrayList<Column>();
        for (Column column : columns.values()) {
            if (!this.createAttribute(column)) continue;
            attributes.add(column);
        }
        return (Column[])attributes.toArray(Column[]::new);
    }

    @Override
    public String getRemarks() throws SQLException {
        if (this.id instanceof Relation) {
            try (ResultSet reflect = this.analyzer.metadata.getTables(this.id.catalog, this.schemaEsc, this.tableEsc, null);){
                while (reflect.next()) {
                    if (!this.filterMetadata(reflect)) continue;
                    String remarks = Strings.trimOrNull((String)this.analyzer.getUniqueString(reflect, "REMARKS"));
                    if (remarks == null) continue;
                    String string = remarks;
                    return string;
                }
            }
        }
        return super.getRemarks();
    }
}

