/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.common.strategy;

import org.apache.shenyu.plugin.ai.common.strategy.FallbackStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.model.ChatResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class SimpleModelFallbackStrategy
implements FallbackStrategy {
    public static final FallbackStrategy INSTANCE = new SimpleModelFallbackStrategy();
    private static final Logger LOG = LoggerFactory.getLogger(SimpleModelFallbackStrategy.class);

    private SimpleModelFallbackStrategy() {
    }

    @Override
    public Mono<ChatResponse> fallback(ChatClient fallbackClient, String requestBody, Throwable originalError) {
        LOG.warn("Executing simple model fallback strategy due to error: {}", (Object)originalError.getMessage());
        return Mono.fromCallable(() -> fallbackClient.prompt().user(requestBody).call().chatResponse()).subscribeOn(Schedulers.boundedElastic()).doOnSuccess(response -> LOG.info("Fallback call successful.")).doOnError(fallbackError -> LOG.error("Fallback call also failed.", fallbackError));
    }

    @Override
    public Flux<ChatResponse> fallbackStream(ChatClient fallbackClient, String requestBody, Throwable originalError) {
        LOG.warn("Executing simple model fallback stream strategy due to error: {}", (Object)originalError.getMessage());
        return Flux.defer(() -> fallbackClient.prompt().user(requestBody).stream().chatResponse()).subscribeOn(Schedulers.boundedElastic()).doOnComplete(() -> LOG.info("Fallback stream completed successfully.")).doOnError(fallbackError -> LOG.error("Fallback stream also failed.", fallbackError));
    }
}

