/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.stat;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class ProxyStatUtils {
    private static final Object cacheLock = new Object();
    private static String cacheIP = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalIP() {
        if (cacheIP == null) {
            Object object = cacheLock;
            synchronized (object) {
                if (cacheIP == null) {
                    try {
                        cacheIP = ProxyStatUtils.getLocalIPByNetworkInterface();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (cacheIP == null) {
                        try {
                            cacheIP = InetAddress.getLocalHost().getHostAddress();
                        }
                        catch (UnknownHostException e) {
                            cacheIP = "0.0.0.0";
                        }
                    }
                }
            }
        }
        return cacheIP;
    }

    private static String getLocalIPByNetworkInterface() throws Exception {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            if (!networkInterface.isUp() || networkInterface.isVirtual() || networkInterface.isLoopback()) continue;
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress inetAddress = addresses.nextElement();
                if (!(inetAddress instanceof Inet4Address)) continue;
                return inetAddress.getHostAddress();
            }
        }
        return null;
    }
}

