/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.support.stat;

import com.qq.tars.common.ClientVersion;
import com.qq.tars.support.stat.ProxyStatBody;
import com.qq.tars.support.stat.ProxyStatHead;
import com.qq.tars.support.stat.ProxyStatUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyStat {
    public static final List<Integer> DEFAULT_TIME_STAT_INTERVAL = new ArrayList<Integer>();
    private ConcurrentHashMap<ProxyStatHead, ProxyStatBody> stat = new ConcurrentHashMap();

    public void setTimeStatInterval(ProxyStatHead head, List<Integer> timeStatInterval) {
        if (this.stat.containsKey(head)) {
            this.stat.get(head).setTimeStatInterval(timeStatInterval);
        }
    }

    private ProxyStatBody getStatBody(ProxyStatHead head) {
        ProxyStatBody body = this.stat.get(head);
        if (body == null) {
            this.stat.putIfAbsent(head, new ProxyStatBody(DEFAULT_TIME_STAT_INTERVAL));
        }
        return this.stat.get(head);
    }

    public void addInvokeTime(ProxyStatHead head, long costTimeMill, int result) {
        if (result == 0) {
            this.getStatBody(head).onCallFinished(costTimeMill, 0);
        } else if (result == 1) {
            this.getStatBody(head).onCallFinished(costTimeMill, 1);
        } else if (result == 2) {
            this.getStatBody(head).onCallFinished(costTimeMill, 2);
        }
    }

    public void addInvokeTimeByClient(String masterName, String slaveName, String slaveSetName, String slaveSetArea, String slaveSetID, String methodName, String slaveIp, int slavePort, int result, long costTimeMill) {
        ProxyStatHead head = new ProxyStatHead(masterName, slaveName, methodName, ProxyStatUtils.getLocalIP(), slaveIp, slavePort, result, slaveSetName, slaveSetArea, slaveSetID, "");
        this.addInvokeTime(head, costTimeMill, result);
    }

    public void addInvokeTimeByServer(String masterName, String application, String server, String slaveSetName, String slaveSetArea, String slaveSetID, String methodName, String masterIp, String slaveIp, int slavePort, int result, long costTimeMill) {
        String slaveName = slaveSetName != null ? String.format("%s.%s.%s%s%s", application, server, slaveSetName, slaveSetArea, slaveSetID) : String.format("%s.%s", application, server);
        ProxyStatHead head = new ProxyStatHead(masterName, slaveName, methodName, masterIp, slaveIp, slavePort, result, slaveSetName, slaveSetArea, slaveSetID, ClientVersion.getVersion());
        this.addInvokeTime(head, costTimeMill, result);
    }

    public List<Integer> getStatIntervals() {
        Collection<ProxyStatBody> collection = this.stat.values();
        if (!collection.isEmpty()) {
            for (ProxyStatBody body : collection) {
                if (body == null) continue;
                return body.timeStatInterval;
            }
        }
        return DEFAULT_TIME_STAT_INTERVAL;
    }

    public ConcurrentHashMap<ProxyStatHead, ProxyStatBody> getStats() {
        return this.stat;
    }

    public int size() {
        return this.stat.size();
    }

    public boolean isEmpty() {
        return this.stat.isEmpty();
    }

    static {
        DEFAULT_TIME_STAT_INTERVAL.add(5);
        DEFAULT_TIME_STAT_INTERVAL.add(10);
        DEFAULT_TIME_STAT_INTERVAL.add(50);
        DEFAULT_TIME_STAT_INTERVAL.add(100);
        DEFAULT_TIME_STAT_INTERVAL.add(200);
        DEFAULT_TIME_STAT_INTERVAL.add(500);
        DEFAULT_TIME_STAT_INTERVAL.add(1000);
        DEFAULT_TIME_STAT_INTERVAL.add(2000);
        DEFAULT_TIME_STAT_INTERVAL.add(3000);
        DEFAULT_TIME_STAT_INTERVAL.add(5000);
        DEFAULT_TIME_STAT_INTERVAL.add(10000);
        DEFAULT_TIME_STAT_INTERVAL.add(100000);
    }
}

