/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common.auth;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.common.auth.Credentials;
import com.aliyun.openservices.log.http.utils.DateUtil;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class ECSRoleCredentials
implements Credentials {
    private static final String META_DATA_SERVICE_URL = "http://100.100.100.200/latest/meta-data/ram/security-credentials/";
    private String ecsRamRole;
    private String accessKeyId;
    private String accessKeySecret;
    private String securityToken;
    private long expiration = 0L;
    private long lastUpdated = 0L;
    private static final double REFRESH_SCALE = 0.8;

    public ECSRoleCredentials(String ecsRamRole) {
        this.ecsRamRole = ecsRamRole;
    }

    private void refreshIfNeeded() {
        long now = System.currentTimeMillis();
        if ((double)(now - this.lastUpdated) > (double)(this.expiration - this.lastUpdated) * 0.8) {
            this.fetchCredentials();
        }
    }

    @Override
    public String getAccessKeyId() {
        this.refreshIfNeeded();
        return this.accessKeyId;
    }

    @Override
    public String getAccessKeySecret() {
        this.refreshIfNeeded();
        return this.accessKeySecret;
    }

    @Override
    public String getSecurityToken() {
        this.refreshIfNeeded();
        return this.securityToken;
    }

    @Override
    public void setAccessKeyId(String accessKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAccessKeySecret(String accessKeySecret) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSecurityToken(String securityToken) {
        throw new UnsupportedOperationException();
    }

    private void fetchCredentials() {
        String requestUrl = META_DATA_SERVICE_URL + this.ecsRamRole;
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpGet httpGet = new HttpGet(requestUrl);
        CloseableHttpResponse httpResponse = null;
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(3000).setConnectionRequestTimeout(3000).setSocketTimeout(3000).build();
            httpGet.setConfig(config);
            httpResponse = httpClient.execute((HttpUriRequest)httpGet);
            JSONObject response = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
            if (response != null && "Success".equalsIgnoreCase(response.getString("Code"))) {
                this.accessKeyId = response.getString("AccessKeyId");
                this.accessKeySecret = response.getString("AccessKeySecret");
                this.securityToken = response.getString("SecurityToken");
                this.expiration = DateUtil.stringToLong(response.getString("Expiration"));
                this.lastUpdated = DateUtil.stringToLong(response.getString("LastUpdated"));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot fetch credentials with role " + this.ecsRamRole, e);
        }
        finally {
            try {
                if (httpResponse != null) {
                    httpResponse.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

