/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.httpclient.config.HttpClientProperties;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import reactor.netty.http.Http11SslContextSpec;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.HttpProtocol;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.SslProvider;
import reactor.netty.transport.ProxyProvider;

public class HttpClientFactory
extends AbstractFactoryBean<HttpClient> {
    private final HttpClientProperties properties;
    private final LoopResources loopResources;
    private final ServerProperties serverProperties;

    public HttpClientFactory(HttpClientProperties httpClientProperties, LoopResources loopResources, ServerProperties serverProperties) {
        this.properties = httpClientProperties;
        this.loopResources = loopResources;
        this.serverProperties = serverProperties;
    }

    public Class<?> getObjectType() {
        return HttpClient.class;
    }

    private HttpClient setHttpClientProxy(HttpClient httpClient, HttpClientProperties.Proxy proxy) {
        return (HttpClient)httpClient.proxy(proxySpec -> {
            ProxyProvider.Builder builder = proxySpec.type(ProxyProvider.Proxy.HTTP).host(proxy.getHost());
            PropertyMapper map = PropertyMapper.get();
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getPort()).whenNonNull().to(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getUsername()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).username(arg_0));
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getPassword()).whenHasText().to(password -> builder.password(s -> password));
            map.from(() -> ((HttpClientProperties.Proxy)proxy).getNonProxyHostsPattern()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).nonProxyHosts(arg_0));
        });
    }

    private void setSsl(SslProvider.SslContextSpec sslContextSpec, HttpClientProperties.Ssl ssl) {
        Http2SslContextSpec clientSslContext = this.serverProperties.getHttp2().isEnabled() ? Http2SslContextSpec.forClient() : Http11SslContextSpec.forClient();
        clientSslContext.configure(sslContextBuilder -> {
            Object[] trustedX509Certificates = ssl.getTrustedX509CertificatesForTrustManager();
            if (ArrayUtils.isNotEmpty((Object[])trustedX509Certificates)) {
                sslContextBuilder.trustManager((X509Certificate[])trustedX509Certificates);
            } else if (ssl.isUseInsecureTrustManager()) {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            sslContextBuilder.keyManager(ssl.getKeyManagerFactory());
        });
        sslContextSpec.sslContext((SslProvider.ProtocolSslContextSpec)clientSslContext).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
    }

    protected HttpClient createInstance() {
        HttpClientProperties.Ssl ssl;
        HttpClientProperties.Proxy proxy;
        HttpClientProperties.Pool pool = this.properties.getPool();
        ConnectionProvider connectionProvider = this.buildConnectionProvider(pool);
        HttpClient httpClient = (HttpClient)HttpClient.create((ConnectionProvider)connectionProvider).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.properties.getConnectTimeout());
        if (this.serverProperties.getHttp2().isEnabled()) {
            httpClient = httpClient.protocol(new HttpProtocol[]{HttpProtocol.HTTP11, HttpProtocol.H2});
        }
        if (StringUtils.isNotEmpty((CharSequence)(proxy = this.properties.getProxy()).getHost())) {
            httpClient = this.setHttpClientProxy(httpClient, proxy);
        }
        httpClient.doOnConnected(connection -> {
            connection.addHandlerLast((ChannelHandler)new IdleStateHandler((long)this.properties.getReaderIdleTime().intValue(), (long)this.properties.getWriterIdleTime().intValue(), (long)this.properties.getAllIdleTime().intValue(), TimeUnit.MILLISECONDS));
            connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)this.properties.getWriteTimeout().intValue(), TimeUnit.MILLISECONDS));
            connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)this.properties.getReadTimeout().intValue(), TimeUnit.MILLISECONDS));
        });
        if (Objects.nonNull(this.loopResources)) {
            httpClient.runOn(this.loopResources);
        }
        if (StringUtils.isNotEmpty((CharSequence)(ssl = this.properties.getSsl()).getKeyStorePath()) || ArrayUtils.isNotEmpty((Object[])ssl.getTrustedX509CertificatesForTrustManager()) || ssl.isUseInsecureTrustManager()) {
            httpClient = httpClient.secure(sslContextSpec -> this.setSsl((SslProvider.SslContextSpec)sslContextSpec, ssl));
        }
        if (this.properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        return httpClient.keepAlive(this.properties.isKeepAlive());
    }

    private ConnectionProvider buildConnectionProvider(HttpClientProperties.Pool pool) {
        if (pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED) {
            return ConnectionProvider.newConnection();
        }
        ConnectionProvider.Builder builder = ConnectionProvider.builder((String)pool.getName());
        if (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED) {
            this.buildFixedConnectionPool(pool, builder);
        } else {
            this.buildElasticConnectionPool(builder);
        }
        Optional.ofNullable(pool.getMaxIdleTime()).map(Duration::ofMillis).ifPresent(arg_0 -> ((ConnectionProvider.Builder)builder).maxIdleTime(arg_0));
        Optional.ofNullable(pool.getMaxLifeTime()).map(Duration::ofMillis).ifPresent(arg_0 -> ((ConnectionProvider.Builder)builder).maxLifeTime(arg_0));
        Optional.ofNullable(pool.getEvictionInterval()).map(Duration::ofMillis).ifPresent(arg_0 -> ((ConnectionProvider.Builder)builder).evictInBackground(arg_0));
        builder.metrics(pool.getMetrics().booleanValue());
        return builder.build();
    }

    public void buildFixedConnectionPool(HttpClientProperties.Pool pool, ConnectionProvider.Builder builder) {
        if (pool.getMaxConnections() <= 0) {
            throw new IllegalArgumentException("Max Connections value must be strictly positive");
        }
        if (pool.getAcquireTimeout() < 0L) {
            throw new IllegalArgumentException("Acquire Timeout value must be positive");
        }
        ((ConnectionProvider.Builder)((ConnectionProvider.Builder)builder.maxConnections(pool.getMaxConnections().intValue())).pendingAcquireTimeout(Duration.ofMillis(pool.getAcquireTimeout()))).pendingAcquireMaxCount(-1);
    }

    public void buildElasticConnectionPool(ConnectionProvider.Builder builder) {
        ((ConnectionProvider.Builder)((ConnectionProvider.Builder)builder.maxConnections(Integer.MAX_VALUE)).pendingAcquireTimeout(Duration.ofMillis(0L))).pendingAcquireMaxCount(-1);
    }
}

