/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.global;

import java.net.URI;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.context.ShenyuContextBuilder;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class DefaultShenyuContextBuilder
implements ShenyuContextBuilder {
    private static final String RPC_TYPE = "rpc_type";
    private static final String UPGRADE = "Upgrade";
    private final Map<String, ShenyuContextDecorator> decoratorMap;

    public DefaultShenyuContextBuilder(Map<String, ShenyuContextDecorator> decoratorMap) {
        this.decoratorMap = decoratorMap;
    }

    public ShenyuContext build(ServerWebExchange exchange) {
        Pair<String, MetaData> buildData = this.buildData(exchange);
        return this.decoratorMap.get(buildData.getLeft()).decorator(this.buildDefaultContext(exchange.getRequest()), (MetaData)buildData.getRight());
    }

    private Pair<String, MetaData> buildData(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        String rpcType = headers.getFirst(RPC_TYPE);
        if (StringUtils.isNotEmpty((CharSequence)rpcType)) {
            return Pair.of((Object)rpcType, (Object)new MetaData());
        }
        String upgrade = headers.getFirst(UPGRADE);
        if (StringUtils.isNotEmpty((CharSequence)upgrade) && RpcTypeEnum.WEB_SOCKET.getName().equals(upgrade)) {
            return Pair.of((Object)RpcTypeEnum.WEB_SOCKET.getName(), (Object)new MetaData());
        }
        MetaData metaData = MetaDataCache.getInstance().obtain(request.getURI().getRawPath());
        if (Objects.nonNull(metaData) && Boolean.TRUE.equals(metaData.getEnabled())) {
            exchange.getAttributes().put("metaData", metaData);
            return Pair.of((Object)metaData.getRpcType(), (Object)metaData);
        }
        return Pair.of((Object)RpcTypeEnum.HTTP.getName(), (Object)new MetaData());
    }

    private ShenyuContext buildDefaultContext(ServerHttpRequest request) {
        ShenyuContext shenyuContext = new ShenyuContext();
        URI requestURI = request.getURI();
        shenyuContext.setPath(requestURI.getRawPath());
        shenyuContext.setStartDateTime(LocalDateTime.now());
        Optional.ofNullable(request.getMethod()).ifPresent(httpMethod -> shenyuContext.setHttpMethod(httpMethod.name()));
        return shenyuContext;
    }
}

