/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.handler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.BaseData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.PluginHandlerEventEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.PluginHandlerEvent;
import org.apache.shenyu.web.loader.ShenyuLoaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.lang.NonNull;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class ShenyuWebHandler
implements WebHandler,
ApplicationListener<PluginHandlerEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuWebHandler.class);
    private volatile List<ShenyuPlugin> plugins;
    private final List<ShenyuPlugin> sourcePlugins;
    private final ShenyuLoaderService shenyuLoaderService;
    private final boolean scheduled;
    private Scheduler scheduler;

    public ShenyuWebHandler(List<ShenyuPlugin> plugins, ShenyuLoaderService shenyuLoaderService, ShenyuConfig shenyuConfig) {
        this.sourcePlugins = new ArrayList<ShenyuPlugin>(plugins);
        this.plugins = new ArrayList<ShenyuPlugin>(plugins);
        this.shenyuLoaderService = shenyuLoaderService;
        ShenyuConfig.Scheduler config = shenyuConfig.getScheduler();
        this.scheduled = config.getEnabled();
        if (this.scheduled) {
            this.scheduler = Objects.equals(config.getType(), "fixed") ? Schedulers.newParallel((String)"shenyu-work-threads", (int)config.getThreads()) : Schedulers.boundedElastic();
        }
    }

    public void before(ServerWebExchange exchange) {
        exchange.getAttributes().put("chainStartTime:", System.currentTimeMillis());
    }

    public void after(ServerWebExchange exchange) {
        Map attributes = exchange.getAttributes();
        long currentTimeMillis = System.currentTimeMillis();
        long startTime = (Long)attributes.get("chainStartTime:");
        LOG.debug("shenyu chain handle uri:{}, traceId:{}, cost:{}", new Object[]{exchange.getRequest().getPath(), exchange.getLogPrefix(), currentTimeMillis - startTime});
        attributes.remove("chainStartTime:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mono<Void> handle(@NonNull ServerWebExchange exchange) {
        try {
            this.before(exchange);
            Mono<Void> execute = new DefaultShenyuPluginChain(this.plugins).execute(exchange);
            if (this.scheduled) {
                Mono mono = execute.subscribeOn(this.scheduler);
                return mono;
            }
            Mono<Void> mono = execute;
            return mono;
        }
        finally {
            this.after(exchange);
        }
    }

    public List<ShenyuPlugin> getPlugins() {
        return this.plugins;
    }

    public void putExtPlugins(List<ShenyuPlugin> extPlugins) {
        if (CollectionUtils.isEmpty(extPlugins)) {
            return;
        }
        List<ShenyuPlugin> shenyuAddPlugins = extPlugins.stream().filter(e -> this.plugins.stream().noneMatch(plugin -> plugin.named().equals(e.named()))).collect(Collectors.toList());
        List<ShenyuPlugin> shenyuUpdatePlugins = extPlugins.stream().filter(e -> this.plugins.stream().anyMatch(plugin -> plugin.named().equals(e.named()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(shenyuAddPlugins) && CollectionUtils.isEmpty(shenyuUpdatePlugins)) {
            return;
        }
        ArrayList<ShenyuPlugin> newPluginList = new ArrayList<ShenyuPlugin>(this.plugins);
        this.sourcePlugins.addAll(shenyuAddPlugins);
        if (CollectionUtils.isNotEmpty(shenyuAddPlugins)) {
            shenyuAddPlugins.forEach(plugin -> LOG.info("shenyu auto add extends plugins:{}", (Object)plugin.named()));
            newPluginList.addAll(shenyuAddPlugins);
        }
        if (CollectionUtils.isNotEmpty(shenyuUpdatePlugins)) {
            shenyuUpdatePlugins.forEach(plugin -> LOG.info("shenyu auto update extends plugins:{}", (Object)plugin.named()));
            for (ShenyuPlugin updatePlugin : shenyuUpdatePlugins) {
                int i;
                for (i = 0; i < newPluginList.size(); ++i) {
                    if (!((ShenyuPlugin)newPluginList.get(i)).named().equals(updatePlugin.named())) continue;
                    newPluginList.set(i, updatePlugin);
                }
                for (i = 0; i < this.sourcePlugins.size(); ++i) {
                    if (!this.sourcePlugins.get(i).named().equals(updatePlugin.named())) continue;
                    this.sourcePlugins.set(i, updatePlugin);
                }
            }
        }
        this.plugins = this.sortPlugins(newPluginList);
    }

    public void onApplicationEvent(PluginHandlerEvent event) {
        PluginHandlerEventEnum stateEnums = event.getPluginStateEnums();
        PluginData pluginData = (PluginData)event.getSource();
        switch (stateEnums) {
            case ENABLED: {
                this.onPluginEnabled(pluginData);
                break;
            }
            case DELETE: 
            case DISABLED: {
                this.onPluginRemoved(pluginData);
                break;
            }
            case SORTED: {
                this.plugins = this.sortPlugins(new ArrayList<ShenyuPlugin>(this.plugins));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + event.getPluginStateEnums());
            }
        }
    }

    private List<ShenyuPlugin> sortPlugins(List<ShenyuPlugin> list) {
        Map<String, Integer> pluginSortMap = list.stream().collect(Collectors.toMap(ShenyuPlugin::named, plugin -> {
            PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(plugin.named());
            return Optional.ofNullable(pluginData).map(BaseData::getSort).orElse(plugin.getOrder());
        }));
        list.sort(Comparator.comparingLong(plugin -> ((Integer)pluginSortMap.get(plugin.named())).intValue()));
        return list;
    }

    private synchronized void onPluginEnabled(PluginData pluginData) {
        LOG.info("shenyu use plugin:[{}]", (Object)pluginData.getName());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{pluginData.getPluginJar()})) {
            LOG.info("shenyu start load plugin [{}] from upload plugin jar", (Object)pluginData.getName());
            this.shenyuLoaderService.loadExtOrUploadPlugins(pluginData);
        }
        List enabledPlugins = this.sourcePlugins.stream().filter(plugin -> plugin.named().equals(pluginData.getName()) && pluginData.getEnabled() != false).collect(Collectors.toList());
        enabledPlugins.removeAll(this.plugins);
        ArrayList<ShenyuPlugin> newPluginList = new ArrayList<ShenyuPlugin>(this.plugins);
        newPluginList.addAll(enabledPlugins);
        this.plugins = this.sortPlugins(newPluginList);
    }

    private synchronized void onPluginRemoved(PluginData pluginData) {
        ArrayList<ShenyuPlugin> newPluginList = new ArrayList<ShenyuPlugin>(this.plugins);
        newPluginList.removeIf(plugin -> plugin.named().equals(pluginData.getName()));
        this.plugins = newPluginList;
    }

    private static class DefaultShenyuPluginChain
    implements ShenyuPluginChain {
        private int index;
        private final List<ShenyuPlugin> plugins;

        DefaultShenyuPluginChain(List<ShenyuPlugin> plugins) {
            this.plugins = plugins;
        }

        public Mono<Void> execute(ServerWebExchange exchange) {
            return Mono.defer(() -> {
                if (this.index < this.plugins.size()) {
                    ShenyuPlugin plugin;
                    boolean skip;
                    if (skip = (plugin = this.plugins.get(this.index++)).skip(exchange)) {
                        return this.execute(exchange);
                    }
                    try {
                        plugin.before(exchange);
                        Mono mono = plugin.execute(exchange, (ShenyuPluginChain)this);
                        return mono;
                    }
                    finally {
                        plugin.after(exchange);
                    }
                }
                return Mono.empty();
            });
        }
    }
}

