/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import okhttp3.Headers;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.http.utils.OkHttpTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RegisterUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisterUtils.class);

    private RegisterUtils() {
    }

    public static void doRegister(String json, String url, String type, String accessToken) throws IOException {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            LOGGER.error("{} client register error accessToken is null, please check the config : {} ", (Object)type, (Object)json);
            return;
        }
        Headers headers = new Headers.Builder().add("X-Access-Token", accessToken).build();
        String result = OkHttpTools.getInstance().post(url, json, headers);
        if (Objects.equals("success", result)) {
            LOGGER.info("{} client register success: {} ", (Object)type, (Object)json);
        } else {
            LOGGER.error("{} client register error: {} ", (Object)type, (Object)json);
        }
    }

    public static void doRegister(String json, String url, String type) throws IOException {
        String result = OkHttpTools.getInstance().post(url, json);
        if (Objects.equals("success", result)) {
            LOGGER.info("{} client register success: {} ", (Object)type, (Object)json);
        } else {
            LOGGER.error("{} client register error: {} ", (Object)type, (Object)json);
        }
    }

    public static void doHeartBeat(String json, String url, String type, String accessToken) throws IOException {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            LOGGER.error("{} client heartbeat error accessToken is null, please check the config : {} ", (Object)type, (Object)json);
            return;
        }
        Headers headers = new Headers.Builder().add("X-Access-Token", accessToken).build();
        String result = OkHttpTools.getInstance().post(url, json, headers);
        if (Objects.equals("success", result)) {
            LOGGER.info("{} success: {} ", (Object)type, (Object)json);
        } else {
            LOGGER.error("{} error: {} ", (Object)type, (Object)json);
        }
    }

    public static void doUnregister(String json, String url, String accessToken) throws IOException {
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            LOGGER.error("{} client unregister error accessToken is null, please check the config : {} ", (Object)"uri", (Object)json);
            return;
        }
        Headers headers = new Headers.Builder().add("X-Access-Token", accessToken).build();
        String result = OkHttpTools.getInstance().post(url, json, headers);
        if (Objects.equals("success", result)) {
            LOGGER.info("{} client unregister success: {} ", (Object)"uri", (Object)json);
        } else {
            LOGGER.error("{} client unregister error: {} ", (Object)"uri", (Object)json);
        }
    }

    public static Optional<Object> doLogin(String username, String password, String url) throws IOException {
        HashMap<String, Object> loginMap = new HashMap<String, Object>(2);
        loginMap.put("userName", username);
        loginMap.put("password", password);
        String result = OkHttpTools.getInstance().get(url, loginMap);
        Map resultMap = GsonUtils.getInstance().convertToMap(result);
        if (!String.valueOf(200).equals(String.valueOf(resultMap.get("code")))) {
            return Optional.empty();
        }
        String tokenJson = GsonUtils.getInstance().toJson(resultMap.get("data"));
        LOGGER.info("login success: {} ", (Object)tokenJson);
        Map tokenMap = GsonUtils.getInstance().convertToMap(tokenJson);
        return Optional.ofNullable(tokenMap.get("token"));
    }
}

