/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.http;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.AesUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.FailbackRegistryRepository;
import org.apache.shenyu.register.client.http.utils.RegisterUtils;
import org.apache.shenyu.register.client.http.utils.RuntimeUtils;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.DiscoveryConfigRegisterDTO;
import org.apache.shenyu.register.common.dto.InstanceBeatInfoDTO;
import org.apache.shenyu.register.common.dto.McpToolsRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.spi.Join;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class HttpClientRegisterRepository
extends FailbackRegistryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientRegisterRepository.class);
    private static URIRegisterDTO uriRegisterDTO;
    private static ApiDocRegisterDTO apiDocRegisterDTO;
    private String username;
    private String password;
    private List<String> serverList;
    private LoadingCache<String, String> accessToken;

    public HttpClientRegisterRepository() {
    }

    public HttpClientRegisterRepository(ShenyuRegisterCenterConfig config) {
        this.init(config);
    }

    public void init(ShenyuRegisterCenterConfig config) {
        this.username = config.getProps().getProperty("username");
        this.password = config.getProps().getProperty("password");
        String secretKey = config.getProps().getProperty("aes-secret-key");
        String secretIv = config.getProps().getProperty("aes-secret-iv");
        if (StringUtils.isNotBlank((CharSequence)secretKey) && StringUtils.isNotBlank((CharSequence)secretIv)) {
            this.password = AesUtils.cbcEncrypt((String)secretKey, (String)secretIv, (String)this.password);
        }
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)config.getServerLists()));
        this.accessToken = Caffeine.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, String>(){

            public @Nullable String load(@NonNull String server) {
                try {
                    Optional<Object> login = RegisterUtils.doLogin(HttpClientRegisterRepository.this.username, HttpClientRegisterRepository.this.password, server.concat("/platform/login"));
                    return login.map(String::valueOf).orElse(null);
                }
                catch (Exception e) {
                    LOGGER.error("Login admin url :{} is fail, will retry. cause: {} ", (Object)server, (Object)e.getMessage());
                    return null;
                }
            }
        });
    }

    public void doPersistURI(URIRegisterDTO registerDTO) {
        if (RuntimeUtils.listenByOther(registerDTO.getPort())) {
            return;
        }
        this.doRegister(registerDTO, "/shenyu-client/register-uri", "uri");
        uriRegisterDTO = registerDTO;
    }

    public void offline(URIRegisterDTO offlineDTO) {
        this.doUnregister(offlineDTO);
    }

    public void sendHeartbeat(URIRegisterDTO heartbeatDTO) {
        if (RuntimeUtils.listenByOther(heartbeatDTO.getPort())) {
            return;
        }
        heartbeatDTO.setEventType(EventType.HEARTBEAT);
        this.doHeartbeat(heartbeatDTO, "/shenyu-client/register-uri");
    }

    public void sendHeartbeat(InstanceBeatInfoDTO instanceBeatInfoDTO) {
        this.doHeartbeat(instanceBeatInfoDTO, "/instance/beat");
    }

    protected void doPersistApiDoc(ApiDocRegisterDTO registerDTO) {
        this.doRegister(registerDTO, "/shenyu-client/register-apiDoc", "apiDoc");
        apiDocRegisterDTO = registerDTO;
    }

    public void doPersistInterface(MetaDataRegisterDTO metadata) {
        this.doRegister(metadata, "/shenyu-client/register-metadata", "metadata");
    }

    protected void doPersistMcpTools(McpToolsRegisterDTO registerDTO) {
        this.doRegister(registerDTO, "/shenyu-client/register-mcp", "mcp");
    }

    public void closeRepository() {
        if (Objects.nonNull(uriRegisterDTO)) {
            uriRegisterDTO.setEventType(EventType.DELETED);
            this.doRegister(uriRegisterDTO, "/shenyu-client/register-uri", "uri");
        }
        if (Objects.nonNull(apiDocRegisterDTO)) {
            apiDocRegisterDTO.setEventType(EventType.OFFLINE);
            this.doRegister(apiDocRegisterDTO, "/shenyu-client/register-apiDoc", "apiDoc");
        }
    }

    public void doPersistDiscoveryConfig(DiscoveryConfigRegisterDTO discoveryConfigRegisterDTO) {
        this.doRegister(discoveryConfigRegisterDTO, "/shenyu-client/register-discoveryConfig", "discovery");
    }

    private <T> void doRegister(T t, String path, String type) {
        int i = 0;
        for (String server : this.serverList) {
            ++i;
            String concat = server.concat(path);
            try {
                String accessToken = (String)this.accessToken.get((Object)server);
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    throw new NullPointerException("accessToken is null");
                }
                RegisterUtils.doRegister(GsonUtils.getInstance().toJson(t), concat, type, accessToken);
            }
            catch (Exception e) {
                LOGGER.error("Register admin url :{} is fail, will retry. cause:{}", (Object)server, (Object)e.getMessage());
                if (i != this.serverList.size()) continue;
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void doHeartbeat(T t, String path) {
        int i = 0;
        for (String server : this.serverList) {
            ++i;
            String concat = server.concat(path);
            try {
                String accessToken = (String)this.accessToken.get((Object)server);
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    throw new NullPointerException("accessToken is null");
                }
                RegisterUtils.doHeartBeat(GsonUtils.getInstance().toJson(t), concat, "heartbeat", accessToken);
            }
            catch (Exception e) {
                LOGGER.error("HeartBeat admin url :{} is fail, will retry.", (Object)server, (Object)e);
                if (i != this.serverList.size()) continue;
                throw new RuntimeException(e);
            }
        }
    }

    private <T> void doUnregister(T t) {
        for (String server : this.serverList) {
            String concat = server.concat("/shenyu-client/offline");
            try {
                String accessToken = (String)this.accessToken.get((Object)server);
                if (StringUtils.isBlank((CharSequence)accessToken)) {
                    throw new NullPointerException("accessToken is null");
                }
                RegisterUtils.doUnregister(GsonUtils.getInstance().toJson(t), concat, accessToken);
            }
            catch (Exception e) {
                LOGGER.error("Unregister admin url :{} is fail. cause:{}", (Object)server, (Object)e.getMessage());
            }
        }
    }
}

