/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class IpUtils {
    private static final Pattern IP_PATTERN = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)($|(?!\\.$)\\.)){4}$");
    private static final Pattern NET_CARD_PATTERN = Pattern.compile("(\\d+)$");
    private static final String SYSTEM_ENV_DOCKER_HOST_IP = "docker_host_ip";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String PROPERTY = System.getProperty("networkInterface.priority", "enp<eth<bond");
    private static final List<String> PREFER_LIST = new ArrayList<String>(Arrays.asList(PROPERTY.split("<")));
    private static final Comparator<NetCard> BY_NAME = (card1, card2) -> {
        int card1Score = -1;
        int card2Score = -1;
        for (String pre : PREFER_LIST) {
            if (!card1.getName().contains(pre)) continue;
            card1Score = PREFER_LIST.indexOf(pre);
            break;
        }
        for (String pre : PREFER_LIST) {
            if (!card2.getName().contains(pre)) continue;
            card2Score = PREFER_LIST.indexOf(pre);
            break;
        }
        return card2Score - card1Score;
    };

    private IpUtils() {
    }

    public static String getHost() {
        return IpUtils.getHost(null);
    }

    public static String getHost(String filterHost) {
        String hostIp = null;
        Object pattern = filterHost;
        if ("*".equals(filterHost) || "".equals(filterHost)) {
            pattern = null;
        } else if (Objects.nonNull(filterHost) && !filterHost.contains("*") && !IpUtils.isCompleteHost(filterHost)) {
            pattern = filterHost + "*";
        }
        String dockerHostIp = System.getenv(SYSTEM_ENV_DOCKER_HOST_IP);
        if (Objects.nonNull(dockerHostIp) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dockerHostIp})) {
            return dockerHostIp;
        }
        ArrayList<NetCard> ipv4Result = new ArrayList<NetCard>();
        ArrayList<NetCard> ipv6Result = new ArrayList<NetCard>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    NetCard netCard;
                    InetAddress inetAddress = addresses.nextElement();
                    if (!Objects.nonNull(inetAddress) || inetAddress.isLoopbackAddress()) continue;
                    if (inetAddress instanceof Inet4Address && IpUtils.isCompleteHost(inetAddress.getHostAddress())) {
                        netCard = new NetCard(inetAddress.getHostAddress(), IpUtils.getName(networkInterface.getName()), IpUtils.getNamePostfix(networkInterface.getName()), Integer.parseInt(inetAddress.getHostAddress().split("\\.")[3]));
                        ipv4Result.add(netCard);
                        continue;
                    }
                    netCard = new NetCard(inetAddress.getHostAddress(), IpUtils.getName(networkInterface.getName()), IpUtils.getNamePostfix(networkInterface.getName()));
                    ipv6Result.add(netCard);
                }
            }
            Comparator<NetCard> byNamePostfix = Comparator.comparing(NetCard::getNamePostfix);
            Comparator byIpv4Postfix = (card1, card2) -> card2.getIpv4Postfix() - card1.getIpv4Postfix();
            ipv4Result.sort(BY_NAME.thenComparing(byNamePostfix).thenComparing(byIpv4Postfix));
            ipv6Result.sort(BY_NAME.thenComparing(byNamePostfix));
            if (!ipv4Result.isEmpty()) {
                if (Objects.nonNull(pattern)) {
                    for (NetCard card : ipv4Result) {
                        if (!IpUtils.ipMatch(card.getIp(), (String)pattern)) continue;
                        hostIp = card.getIp();
                        break;
                    }
                } else {
                    hostIp = ((NetCard)ipv4Result.get(0)).getIp();
                }
            } else if (!ipv6Result.isEmpty()) {
                hostIp = ((NetCard)ipv6Result.get(0)).getIp();
            }
            if (Objects.isNull(hostIp)) {
                hostIp = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (SocketException | UnknownHostException ignore) {
            hostIp = LOCALHOST;
        }
        return hostIp;
    }

    public static boolean isCompleteHost(String host) {
        if (Objects.isNull(host)) {
            return false;
        }
        return IP_PATTERN.matcher(host).matches();
    }

    private static boolean ipMatch(String ip, String pattern) {
        int i;
        int m = ip.length();
        int n = pattern.length();
        boolean[][] dp = new boolean[m + 1][n + 1];
        dp[0][0] = true;
        for (i = 1; i <= n && pattern.charAt(i - 1) == '*'; ++i) {
            dp[0][i] = true;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                if (pattern.charAt(j - 1) == '*') {
                    dp[i][j] = dp[i][j - 1] || dp[i - 1][j];
                    continue;
                }
                if (pattern.charAt(j - 1) != '?' && ip.charAt(i - 1) != pattern.charAt(j - 1)) continue;
                dp[i][j] = dp[i - 1][j - 1];
            }
        }
        return dp[m][n];
    }

    private static String getName(String name) {
        Matcher matcher = NET_CARD_PATTERN.matcher(name);
        if (matcher.find()) {
            return name.replace(matcher.group(), "");
        }
        return name;
    }

    private static Integer getNamePostfix(String name) {
        Matcher matcher = NET_CARD_PATTERN.matcher(name);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group());
        }
        return -1;
    }

    public static String getZookeeperHost(String zookeeperUrl) {
        if (Objects.isNull(zookeeperUrl) || zookeeperUrl.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(zookeeperUrl);
            String scheme = uri.getScheme();
            if (Objects.nonNull(scheme) && ("zookeeper".equals(scheme) || "zk".equals(scheme))) {
                return uri.getHost();
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        String[] parts = zookeeperUrl.split(":");
        if (parts.length >= 1) {
            return parts[0];
        }
        return null;
    }

    public static String replaceZookeeperHost(String zookeeperUrl, String replacement) {
        String extractedHost = IpUtils.getZookeeperHost(zookeeperUrl);
        if (Objects.nonNull(extractedHost)) {
            if (IpUtils.isCompleteHost(extractedHost)) {
                return zookeeperUrl;
            }
            return zookeeperUrl.replaceFirst(extractedHost, replacement);
        }
        return zookeeperUrl;
    }

    private static class NetCard
    implements Serializable {
        private String ip;
        private String name;
        private Integer namePostfix;
        private Integer ipv4Postfix;

        NetCard(String ip, String name, Integer namePostfix) {
            this.ip = ip;
            this.name = name;
            this.namePostfix = namePostfix;
        }

        NetCard(String ip, String name, Integer namePostfix, Integer postfix) {
            this.ip = ip;
            this.name = name;
            this.namePostfix = namePostfix;
            this.ipv4Postfix = postfix;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getIpv4Postfix() {
            return this.ipv4Postfix;
        }

        public Integer getNamePostfix() {
            return this.namePostfix;
        }

        public void setNamePostfix(Integer namePostfix) {
            this.namePostfix = namePostfix;
        }
    }
}

