/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.concurrent.MemoryLimitCalculator;
import org.apache.shenyu.common.enums.TrieMatchModeEnum;

public class ShenyuConfig {
    private SwitchConfig switchConfig = new SwitchConfig();
    private FileConfig file = new FileConfig();
    private ExcludePath exclude = new ExcludePath();
    private Health health = new Health();
    private Mcp mcp = new Mcp();
    private FallbackPath fallback = new FallbackPath();
    private ExtPlugin extPlugin = new ExtPlugin();
    private Scheduler scheduler = new Scheduler();
    private UpstreamCheck upstreamCheck = new UpstreamCheck();
    private CrossFilterConfig cross = new CrossFilterConfig();
    private RibbonConfig ribbon = new RibbonConfig();
    private Local local = new Local();
    private WebsocketConfig websocket = new WebsocketConfig();
    private SharedPool sharedPool = new SharedPool();
    private MetricsConfig metrics = new MetricsConfig();
    private SelectorMatchCache selectorMatchCache = new SelectorMatchCache();
    private RuleMatchCache ruleMatchCache = new RuleMatchCache();
    private SpringCloudCacheConfig springCloudCache = new SpringCloudCacheConfig();
    private AlertConfig alert = new AlertConfig();
    private String namespace = "649330b6-c2d7-4edc-be8e-8a54df9eb385";

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Health getHealth() {
        return this.health;
    }

    public void setHealth(Health health) {
        this.health = health;
    }

    public Mcp getMcp() {
        return this.mcp;
    }

    public void setMcp(Mcp mcp) {
        this.mcp = mcp;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricsConfig metrics) {
        this.metrics = metrics;
    }

    public SharedPool getSharedPool() {
        return this.sharedPool;
    }

    public void setSharedPool(SharedPool sharedPool) {
        this.sharedPool = sharedPool;
    }

    public Local getLocal() {
        return this.local;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public RibbonConfig getRibbon() {
        return this.ribbon;
    }

    public void setRibbon(RibbonConfig ribbon) {
        this.ribbon = ribbon;
    }

    public SwitchConfig getSwitchConfig() {
        return this.switchConfig;
    }

    public void setSwitchConfig(SwitchConfig switchConfig) {
        this.switchConfig = switchConfig;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ExtPlugin getExtPlugin() {
        return this.extPlugin;
    }

    public void setExtPlugin(ExtPlugin extPlugin) {
        this.extPlugin = extPlugin;
    }

    public FileConfig getFile() {
        return this.file;
    }

    public void setFile(FileConfig file) {
        this.file = file;
    }

    public ExcludePath getExclude() {
        return this.exclude;
    }

    public void setExclude(ExcludePath exclude) {
        this.exclude = exclude;
    }

    public FallbackPath getFallback() {
        return this.fallback;
    }

    public void setFallback(FallbackPath fallback) {
        this.fallback = fallback;
    }

    public UpstreamCheck getUpstreamCheck() {
        return this.upstreamCheck;
    }

    public void setUpstreamCheck(UpstreamCheck upstreamCheck) {
        this.upstreamCheck = upstreamCheck;
    }

    public CrossFilterConfig getCross() {
        return this.cross;
    }

    public WebsocketConfig getWebsocket() {
        return this.websocket;
    }

    public void setWebsocket(WebsocketConfig websocket) {
        this.websocket = websocket;
    }

    public void setCross(CrossFilterConfig cross) {
        this.cross = cross;
    }

    public SelectorMatchCache getSelectorMatchCache() {
        return this.selectorMatchCache;
    }

    public void setSelectorMatchCache(SelectorMatchCache selectorMatchCache) {
        this.selectorMatchCache = selectorMatchCache;
    }

    public RuleMatchCache getRuleMatchCache() {
        return this.ruleMatchCache;
    }

    public void setRuleMatchCache(RuleMatchCache ruleMatchCache) {
        this.ruleMatchCache = ruleMatchCache;
    }

    public SpringCloudCacheConfig getSpringCloudCache() {
        return this.springCloudCache;
    }

    public void setSpringCloudCache(SpringCloudCacheConfig springCloudCache) {
        this.springCloudCache = springCloudCache;
    }

    public AlertConfig getAlert() {
        return this.alert;
    }

    public void setAlert(AlertConfig alert) {
        this.alert = alert;
    }

    public static class SwitchConfig {
        private boolean local = true;
        private boolean collapseSlashes = true;

        public boolean getLocal() {
            return this.local;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }

        public boolean getCollapseSlashes() {
            return this.collapseSlashes;
        }

        public void setCollapseSlashes(boolean collapseSlashes) {
            this.collapseSlashes = collapseSlashes;
        }
    }

    public static class FileConfig {
        private boolean enabled;
        private Integer maxSize = 10;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class ExcludePath {
        private boolean enabled;
        private List<String> paths = new ArrayList<String>();

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPaths(List<String> paths) {
            this.paths = paths;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    public static class Health {
        private boolean enabled;
        private List<String> paths = new ArrayList<String>();

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPaths(List<String> paths) {
            this.paths = paths;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    public static class Mcp {
        private McpServer server = new McpServer();

        public McpServer getServer() {
            return this.server;
        }

        public void setServer(McpServer server) {
            this.server = server;
        }
    }

    public static class FallbackPath {
        private boolean enabled;
        private List<String> paths = new ArrayList<String>();

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setPaths(List<String> paths) {
            this.paths = paths;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    public static class ExtPlugin {
        private String path;
        private boolean enabled;
        private Integer threads = 1;
        private Integer scheduleTime = 300;
        private Integer scheduleDelay = 30;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }

        public Integer getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(Integer scheduleTime) {
            this.scheduleTime = scheduleTime;
        }

        public Integer getScheduleDelay() {
            return this.scheduleDelay;
        }

        public void setScheduleDelay(Integer scheduleDelay) {
            this.scheduleDelay = scheduleDelay;
        }
    }

    public static class Scheduler {
        private boolean enabled;
        private String type = "fixed";
        private Integer threads = Math.max((Runtime.getRuntime().availableProcessors() << 1) + 1, 16);

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }
    }

    public static class UpstreamCheck {
        private boolean enabled;
        private Integer poolSize = 10;
        private Integer timeout = 3000;
        private Integer healthyThreshold = 1;
        private Integer unhealthyThreshold = 1;
        private Integer interval = 5000;
        private boolean printEnabled;
        private Integer printInterval = 60000;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getPoolSize() {
            return this.poolSize;
        }

        public void setPoolSize(Integer poolSize) {
            this.poolSize = poolSize;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(Integer interval) {
            this.interval = interval;
        }

        public boolean getPrintEnabled() {
            return this.printEnabled;
        }

        public void setPrintEnabled(boolean printEnabled) {
            this.printEnabled = printEnabled;
        }

        public Integer getPrintInterval() {
            return this.printInterval;
        }

        public void setPrintInterval(Integer printInterval) {
            this.printInterval = printInterval;
        }
    }

    public static class CrossFilterConfig {
        private static final Set<String> DEFAULT_ALLOWED_HEADERS = new HashSet<String>(){
            {
                this.add("x-requested-with");
                this.add("authorization");
                this.add("Content-Type");
                this.add("Authorization");
                this.add("credential");
                this.add("X-XSRF-TOKEN");
                this.add("token");
                this.add("username");
                this.add("client");
                this.add("ShenYu-Authorization");
            }
        };
        private boolean enabled;
        private String allowedHeaders = "";
        private String allowedMethods = "*";
        private AllowedOriginConfig allowedOrigin = new AllowedOriginConfig();
        private boolean allowedAnyOrigin;
        private String allowedExpose = "";
        private String maxAge = "18000";
        private boolean allowCredentials;

        private String wrapperHeaders(String headers) {
            Set<String> headerSet = DEFAULT_ALLOWED_HEADERS;
            if (StringUtils.isNotEmpty((CharSequence)headers)) {
                headerSet.addAll(Stream.of(headers.split(",")).collect(Collectors.toSet()));
            }
            return String.join((CharSequence)",", headerSet);
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getAllowedHeaders() {
            this.allowedHeaders = this.wrapperHeaders(this.allowedHeaders);
            return this.allowedHeaders;
        }

        public void setAllowedHeaders(String allowedHeaders) {
            this.allowedHeaders = this.wrapperHeaders(allowedHeaders);
        }

        public String getAllowedMethods() {
            return this.allowedMethods;
        }

        public void setAllowedMethods(String allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public AllowedOriginConfig getAllowedOrigin() {
            return this.allowedOrigin;
        }

        public void setAllowedOrigin(AllowedOriginConfig allowedOrigin) {
            this.allowedOrigin = allowedOrigin;
        }

        public boolean isAllowedAnyOrigin() {
            return this.allowedAnyOrigin;
        }

        public void setAllowedAnyOrigin(boolean allowedAnyOrigin) {
            this.allowedAnyOrigin = allowedAnyOrigin;
        }

        public String getAllowedExpose() {
            return this.allowedExpose;
        }

        public void setAllowedExpose(String allowedExpose) {
            this.allowedExpose = allowedExpose;
        }

        public String getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(String maxAge) {
            this.maxAge = maxAge;
        }

        public boolean isAllowCredentials() {
            return this.allowCredentials;
        }

        public void setAllowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }

        public static class AllowedOriginConfig {
            private String spacer = ".";
            private String domain;
            private Set<String> prefixes = new HashSet<String>();
            private Set<String> origins;
            private String originRegex;

            public String getSpacer() {
                return this.spacer;
            }

            public void setSpacer(String spacer) {
                this.spacer = spacer;
            }

            public String getDomain() {
                return this.domain;
            }

            public void setDomain(String domain) {
                this.domain = domain;
            }

            public Set<String> getPrefixes() {
                return this.prefixes;
            }

            public void setPrefixes(Set<String> prefixes) {
                this.prefixes = prefixes;
            }

            public Set<String> getOrigins() {
                return this.origins;
            }

            public void setOrigins(Set<String> origins) {
                this.origins = origins;
            }

            public String getOriginRegex() {
                return this.originRegex;
            }

            public void setOriginRegex(String originRegex) {
                this.originRegex = originRegex;
            }
        }
    }

    public static class RibbonConfig {
        private Integer serverListRefreshInterval = 10000;

        public RibbonConfig() {
        }

        public RibbonConfig(Integer serverListRefreshInterval) {
            this.serverListRefreshInterval = serverListRefreshInterval;
        }

        public Integer getServerListRefreshInterval() {
            return this.serverListRefreshInterval;
        }

        public void setServerListRefreshInterval(Integer serverListRefreshInterval) {
            this.serverListRefreshInterval = serverListRefreshInterval;
        }
    }

    public static class Local {
        private boolean enabled;
        private String sha512Key;

        public Local() {
        }

        public Local(String sha512Key) {
            this.sha512Key = sha512Key;
        }

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getSha512Key() {
            return this.sha512Key;
        }

        public void setSha512Key(String sha512Key) {
            this.sha512Key = sha512Key;
        }
    }

    public static class WebsocketConfig {
        private Integer maxFramePayloadSize = 10;
        private Boolean enableProxyPing = false;

        public Integer getMaxFramePayloadSize() {
            return this.maxFramePayloadSize;
        }

        public void setMaxFramePayloadSize(Integer maxFramePayloadSize) {
            this.maxFramePayloadSize = maxFramePayloadSize;
        }

        public Boolean getEnableProxyPing() {
            return this.enableProxyPing;
        }

        public void setEnableProxyPing(boolean enableProxyPing) {
            this.enableProxyPing = enableProxyPing;
        }
    }

    public static class SharedPool {
        private Boolean enable = Boolean.FALSE;
        private String prefix = "shenyu-shared";
        private Integer corePoolSize = 200;
        private Integer maximumPoolSize = Integer.MAX_VALUE;
        private Long keepAliveTime = 60000L;
        private Long maxWorkQueueMemory = MemoryLimitCalculator.defaultLimit();
        private Integer maxFreeMemory;

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public Integer getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public void setMaximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public Long getMaxWorkQueueMemory() {
            return this.maxWorkQueueMemory;
        }

        public void setMaxWorkQueueMemory(Long maxWorkQueueMemory) {
            this.maxWorkQueueMemory = maxWorkQueueMemory;
        }

        public Integer getMaxFreeMemory() {
            return this.maxFreeMemory;
        }

        public void setMaxFreeMemory(Integer maxFreeMemory) {
            this.maxFreeMemory = maxFreeMemory;
        }
    }

    public static class MetricsConfig {
        private boolean enabled;
        private String name;
        private String host;
        private Integer port;
        private String jmxConfig;
        private Properties props;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getJmxConfig() {
            return this.jmxConfig;
        }

        public void setJmxConfig(String jmxConfig) {
            this.jmxConfig = jmxConfig;
        }

        public Properties getProps() {
            return this.props;
        }

        public void setProps(Properties props) {
            this.props = props;
        }
    }

    public static class SelectorMatchCache {
        private MatchCacheConfig cache = new MatchCacheConfig();
        private ShenyuTrieConfig trie = new ShenyuTrieConfig();

        public MatchCacheConfig getCache() {
            return this.cache;
        }

        public void setCache(MatchCacheConfig cache) {
            this.cache = cache;
        }

        public ShenyuTrieConfig getTrie() {
            return this.trie;
        }

        public void setTrie(ShenyuTrieConfig trie) {
            this.trie = trie;
        }
    }

    public static class RuleMatchCache {
        private MatchCacheConfig cache = new MatchCacheConfig();
        private ShenyuTrieConfig trie = new ShenyuTrieConfig();

        public MatchCacheConfig getCache() {
            return this.cache;
        }

        public void setCache(MatchCacheConfig cache) {
            this.cache = cache;
        }

        public ShenyuTrieConfig getTrie() {
            return this.trie;
        }

        public void setTrie(ShenyuTrieConfig trie) {
            this.trie = trie;
        }
    }

    public static class SpringCloudCacheConfig {
        private Boolean enabled = Boolean.FALSE;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class AlertConfig {
        private Boolean enabled = Boolean.FALSE;
        private String admins = "localhost:9095";

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getAdmins() {
            return this.admins;
        }

        public void setAdmins(String admins) {
            this.admins = admins;
        }
    }

    public static class ShenyuTrieConfig {
        private Boolean enabled = Boolean.FALSE;
        private Long cacheSize = 512L;
        private String matchMode = TrieMatchModeEnum.ANT_PATH_MATCH.getMatchMode();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Long getCacheSize() {
            return this.cacheSize;
        }

        public void setCacheSize(Long cacheSize) {
            this.cacheSize = cacheSize;
        }

        public String getMatchMode() {
            return this.matchMode;
        }

        public void setMatchMode(String matchMode) {
            this.matchMode = matchMode;
        }
    }

    public static class McpServer {
        private Boolean enabled = Boolean.TRUE;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class MatchCacheConfig {
        private Boolean enabled = Boolean.TRUE;
        private int initialCapacity = 10000;
        private long maximumSize = 10000L;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public void setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        public long getMaximumSize() {
            return this.maximumSize;
        }

        public void setMaximumSize(long maximumSize) {
            this.maximumSize = maximumSize;
        }
    }
}

