/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.appender;

import com.huaweicloud.lts.producer.LogProducer;
import com.huaweicloud.lts.producer.Producer;
import com.huaweicloud.lts.producer.ProducerConfig;
import com.huaweicloud.lts.producer.ProjectConfig;
import com.huaweicloud.lts.producer.exception.ClientException;
import com.huaweicloud.lts.producer.util.Utils;
import java.util.Optional;

public class JavaSDKAppender {
    private String projectId;
    private String accessKeyId;
    private String accessKeySecret;
    private String regionName;
    private Producer producer;
    private Integer totalSizeInBytes;
    private Long maxBlockMs;
    private Integer ioThreadCount;
    private Integer batchSizeThresholdInBytes;
    private Integer batchCountThreshold;
    private Integer lingerMs;
    private Integer retries;
    private Integer maxReservedAttempts;
    private Long baseRetryBackoffMs;
    private Long maxRetryBackoffMs;
    private Integer maxSingleLogSizeInBytes;
    private Boolean enableLocalTest;
    private Boolean giveUpExtraLongSingleLog;

    private JavaSDKAppender() {
    }

    public Producer getProducer() throws ClientException {
        Utils.assertArgumentNotNullOrEmpty((String)this.accessKeyId, (String)"accessKeyId");
        Utils.assertArgumentNotNullOrEmpty((String)this.accessKeySecret, (String)"accessKeySecret");
        Utils.assertArgumentNotNullOrEmpty((String)this.projectId, (String)"projectId");
        Utils.assertArgumentNotNullOrEmpty((String)this.regionName, (String)"regionName");
        ProjectConfig projectConfig = this.buildProjectConfig();
        ProducerConfig producerConfig = new ProducerConfig();
        this.setProducerConfig(producerConfig);
        producerConfig.setProjectId(this.projectId);
        LogProducer producer = new LogProducer(producerConfig);
        producer.putProjectConfig(projectConfig);
        return producer;
    }

    private void setProducerConfig(ProducerConfig producerConfig) {
        Optional.ofNullable(this.totalSizeInBytes).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setTotalSizeInBytes(arg_0));
        Optional.ofNullable(this.maxBlockMs).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setMaxBlockMs(arg_0));
        Optional.ofNullable(this.ioThreadCount).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setIoThreadCount(arg_0));
        Optional.ofNullable(this.batchSizeThresholdInBytes).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setBatchSizeThresholdInBytes(arg_0));
        Optional.ofNullable(this.batchCountThreshold).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setBatchCountThreshold(arg_0));
        Optional.ofNullable(this.lingerMs).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setLingerMs(arg_0));
        Optional.ofNullable(this.retries).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setRetries(arg_0));
        Optional.ofNullable(this.maxReservedAttempts).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setMaxReservedAttempts(arg_0));
        Optional.ofNullable(this.baseRetryBackoffMs).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setBaseRetryBackoffMs(arg_0));
        Optional.ofNullable(this.maxRetryBackoffMs).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setMaxRetryBackoffMs(arg_0));
        Optional.ofNullable(this.maxSingleLogSizeInBytes).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setMaxSingleLogSizeInBytes(arg_0));
        Optional.ofNullable(this.enableLocalTest).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setEnableLocalTest(arg_0));
        Optional.ofNullable(this.giveUpExtraLongSingleLog).ifPresent(arg_0 -> ((ProducerConfig)producerConfig).setGiveUpExtraLongSingleLog(arg_0));
    }

    private ProjectConfig buildProjectConfig() {
        return new ProjectConfig(this.projectId, this.regionName, this.accessKeyId, this.accessKeySecret);
    }

    public static Builder custom() {
        return new Builder();
    }

    public static final class Builder {
        private String projectId;
        private String accessKeyId;
        private String accessKeySecret;
        private String regionName;
        private Integer totalSizeInBytes;
        private Long maxBlockMs;
        private Integer ioThreadCount;
        private Integer batchSizeThresholdInBytes;
        private Integer batchCountThreshold;
        private Integer lingerMs;
        private Integer retries;
        private Integer maxReservedAttempts;
        private Long baseRetryBackoffMs;
        private Long maxRetryBackoffMs;
        private Integer maxSingleLogSizeInBytes;
        private Boolean enableLocalTest;
        private Boolean giveUpExtraLongSingleLog;

        public Builder setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder setAccessKeySecret(String accessKeySecret) {
            this.accessKeySecret = accessKeySecret;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder setRegionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public Builder setTotalSizeInBytes(Integer totalSizeInBytes) {
            this.totalSizeInBytes = totalSizeInBytes;
            return this;
        }

        public Builder setMaxBlockMs(Long maxBlockMs) {
            this.maxBlockMs = maxBlockMs;
            return this;
        }

        public Builder setIoThreadCount(Integer ioThreadCount) {
            this.ioThreadCount = ioThreadCount;
            return this;
        }

        public Builder setBatchSizeThresholdInBytes(Integer batchSizeThresholdInBytes) {
            this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
            return this;
        }

        public Builder setBatchCountThreshold(Integer batchCountThreshold) {
            this.batchCountThreshold = batchCountThreshold;
            return this;
        }

        public Builder setLingerMs(Integer lingerMs) {
            this.lingerMs = lingerMs;
            return this;
        }

        public Builder setRetries(Integer retries) {
            this.retries = retries;
            return this;
        }

        public Builder setMaxReservedAttempts(Integer maxReservedAttempts) {
            this.maxReservedAttempts = maxReservedAttempts;
            return this;
        }

        public Builder setBaseRetryBackoffMs(Long baseRetryBackoffMs) {
            this.baseRetryBackoffMs = baseRetryBackoffMs;
            return this;
        }

        public Builder setMaxRetryBackoffMs(Long maxRetryBackoffMs) {
            this.maxRetryBackoffMs = maxRetryBackoffMs;
            return this;
        }

        public Builder setMaxSingleLogSizeInBytes(Integer maxSingleLogSizeInBytes) {
            this.maxSingleLogSizeInBytes = maxSingleLogSizeInBytes;
            return this;
        }

        public Builder setEnableLocalTest(Boolean enableLocalTest) {
            this.enableLocalTest = enableLocalTest;
            return this;
        }

        public Builder setGiveUpExtraLongSingleLog(Boolean giveUpExtraLongSingleLog) {
            this.giveUpExtraLongSingleLog = giveUpExtraLongSingleLog;
            return this;
        }

        public JavaSDKAppender builder() throws ClientException {
            JavaSDKAppender javaSDKAppender = new JavaSDKAppender();
            Utils.assertArgumentNotNullOrEmpty((String)this.accessKeyId, (String)"accessKeyId");
            Utils.assertArgumentNotNullOrEmpty((String)this.accessKeySecret, (String)"accessKeySecret");
            Utils.assertArgumentNotNullOrEmpty((String)this.projectId, (String)"projectId");
            Utils.assertArgumentNotNullOrEmpty((String)this.regionName, (String)"regionName");
            javaSDKAppender.projectId = this.projectId;
            javaSDKAppender.accessKeyId = this.accessKeyId;
            javaSDKAppender.accessKeySecret = this.accessKeySecret;
            javaSDKAppender.regionName = this.regionName;
            javaSDKAppender.totalSizeInBytes = this.totalSizeInBytes;
            javaSDKAppender.maxBlockMs = this.maxBlockMs;
            javaSDKAppender.ioThreadCount = this.ioThreadCount;
            javaSDKAppender.batchSizeThresholdInBytes = this.batchSizeThresholdInBytes;
            javaSDKAppender.batchCountThreshold = this.batchCountThreshold;
            javaSDKAppender.lingerMs = this.lingerMs;
            javaSDKAppender.retries = this.retries;
            javaSDKAppender.maxReservedAttempts = this.maxReservedAttempts;
            javaSDKAppender.baseRetryBackoffMs = this.baseRetryBackoffMs;
            javaSDKAppender.maxRetryBackoffMs = this.maxRetryBackoffMs;
            javaSDKAppender.maxSingleLogSizeInBytes = this.maxSingleLogSizeInBytes;
            javaSDKAppender.enableLocalTest = this.enableLocalTest;
            javaSDKAppender.giveUpExtraLongSingleLog = this.giveUpExtraLongSingleLog;
            return javaSDKAppender;
        }
    }
}

