/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.v2motan;

import com.weibo.api.motan.exception.MotanServiceException;
import java.nio.ByteBuffer;

public class MotanV2Header {
    public static final short MAGIC = -3599;
    private int version = 1;
    private boolean heartbeat = false;
    private boolean gzip = false;
    private boolean oneway = false;
    private boolean proxy = false;
    private boolean request = true;
    private int status = 0;
    private int serialize = 1;
    private long requestId;

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public boolean isHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(boolean heartbeat) {
        this.heartbeat = heartbeat;
    }

    public boolean isGzip() {
        return this.gzip;
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public boolean isOneway() {
        return this.oneway;
    }

    public void setOneway(boolean oneway) {
        this.oneway = oneway;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void setProxy(boolean proxy) {
        this.proxy = proxy;
    }

    public boolean isRequest() {
        return this.request;
    }

    public void setRequest(boolean request) {
        this.request = request;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getSerialize() {
        return this.serialize;
    }

    public void setSerialize(int serialize) {
        this.serialize = serialize;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.allocate(13);
        buf.putShort((short)-3599);
        byte msgType = 0;
        if (this.heartbeat) {
            msgType = (byte)(msgType | 0x10);
        }
        if (this.gzip) {
            msgType = (byte)(msgType | 8);
        }
        if (this.oneway) {
            msgType = (byte)(msgType | 4);
        }
        if (this.proxy) {
            msgType = (byte)(msgType | 2);
        }
        if (!this.request) {
            msgType = (byte)(msgType | 1);
        }
        buf.put(msgType);
        byte vs = 8;
        if (this.version != 1) {
            vs = (byte)(this.version << 3 & 0xF8);
        }
        if (this.status != 0) {
            vs = (byte)(vs | this.status & 7);
        }
        buf.put(vs);
        byte se = 8;
        if (this.serialize != 1) {
            se = (byte)(this.serialize << 3 & 0xF8);
        }
        buf.put(se);
        buf.putLong(this.requestId);
        buf.flip();
        return buf.array();
    }

    public static MotanV2Header buildHeader(byte[] headerBytes) {
        ByteBuffer buf = ByteBuffer.wrap(headerBytes);
        short mg = buf.getShort();
        if (mg != -3599) {
            throw new MotanServiceException("decode motan v2 header fail. magicnum not correct. magic:" + mg);
        }
        MotanV2Header header = new MotanV2Header();
        byte b = buf.get();
        if ((b & 0x10) == 16) {
            header.setHeartbeat(true);
        }
        if ((b & 8) == 8) {
            header.setGzip(true);
        }
        if ((b & 4) == 4) {
            header.setOneway(true);
        }
        if ((b & 2) == 2) {
            header.setProxy(true);
        }
        if ((b & 1) == 1) {
            header.setRequest(false);
        }
        b = buf.get();
        header.setVersion(b >>> 3 & 0x1F);
        header.setStatus(b & 7);
        b = buf.get();
        header.setSerialize(b >>> 3 & 0x1F);
        header.setRequestId(buf.getLong());
        return header;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MotanV2Header that = (MotanV2Header)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.heartbeat != that.heartbeat) {
            return false;
        }
        if (this.gzip != that.gzip) {
            return false;
        }
        if (this.oneway != that.oneway) {
            return false;
        }
        if (this.proxy != that.proxy) {
            return false;
        }
        if (this.request != that.request) {
            return false;
        }
        if (this.status != that.status) {
            return false;
        }
        if (this.serialize != that.serialize) {
            return false;
        }
        return this.requestId == that.requestId;
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + (this.heartbeat ? 1 : 0);
        result = 31 * result + (this.gzip ? 1 : 0);
        result = 31 * result + (this.oneway ? 1 : 0);
        result = 31 * result + (this.proxy ? 1 : 0);
        result = 31 * result + (this.request ? 1 : 0);
        result = 31 * result + this.status;
        result = 31 * result + this.serialize;
        result = 31 * result + (int)(this.requestId ^ this.requestId >>> 32);
        return result;
    }

    public static enum MessageStatus {
        NORMAL(0),
        EXCEPTION(1);

        private final int status;

        private MessageStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }
    }
}

