/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.param;

import com.alipay.hessian.generic.model.GenericCollection;
import com.alipay.hessian.generic.model.GenericMap;
import com.alipay.hessian.generic.model.GenericObject;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.ParamCheckUtils;
import org.apache.shenyu.plugin.sofa.param.SofaParamResolveService;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class SofaParamResolveServiceImpl
implements SofaParamResolveService {
    @Override
    @NonNull
    public Pair<String[], Object[]> buildParameter(String body, String parameterTypes) {
        String[] parameterTypeStrings = StringUtils.split((String)parameterTypes, (String)",");
        ArrayList<String> parameterTypeArr = new ArrayList<String>(parameterTypeStrings.length);
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList params = new ArrayList(GsonUtils.getInstance().toObjectMap(body).values());
        for (int paramIndex = 0; paramIndex < parameterTypeStrings.length; ++paramIndex) {
            ParamCheckUtils.checkParamsLength((Integer)params.size(), (Integer)parameterTypeStrings.length);
            String[] parameter = StringUtils.split((String)parameterTypeStrings[paramIndex], (String)"#");
            parameterTypeArr.add(parameter[0]);
            values.add(this.convertToParameterValue(params.get(paramIndex), parameter));
        }
        return new ImmutablePair((Object)parameterTypeArr.toArray(new String[0]), (Object)values.toArray());
    }

    private Object convertToParameterValue(Object value, String[] parameterType) {
        if (SofaParamResolveServiceImpl.isSingleType(parameterType)) {
            return value;
        }
        if (value instanceof JsonObject && parameterType[0].contains("Map")) {
            Map mapValue = GsonUtils.getInstance().convertToMap(value.toString());
            if (parameterType.length == 1) {
                return mapValue;
            }
            Assert.state((parameterType.length == 3 ? 1 : 0) != 0, (String)"parameterType length must be 3.");
            GenericMap genericMap = new GenericMap(parameterType[2]);
            mapValue.replaceAll((k, v) -> SofaParamResolveServiceImpl.convertToGenericObject(parameterType[2], mapValue.get(k)));
            genericMap.setMap(mapValue);
            return genericMap;
        }
        if (value instanceof JsonObject) {
            return SofaParamResolveServiceImpl.convertToGenericObject(parameterType[0], value);
        }
        if (value instanceof JsonArray) {
            if (parameterType.length == 1) {
                return GsonUtils.getInstance().fromList(value.toString(), Object.class);
            }
            GenericCollection genericCollection = new GenericCollection(parameterType[1]);
            genericCollection.setCollection(SofaParamResolveServiceImpl.convertToGenericObjects(parameterType[1], (Iterable)value));
            return genericCollection;
        }
        return value;
    }

    private static Object convertToGenericObject(String paramType, Object paramValue) {
        if (SofaParamResolveServiceImpl.isSingleType(paramType)) {
            return paramValue;
        }
        Map mapValue = GsonUtils.getInstance().convertToMap(paramValue.toString());
        GenericObject genericObject = new GenericObject(paramType);
        mapValue.forEach((arg_0, arg_1) -> ((GenericObject)genericObject).putField(arg_0, arg_1));
        return genericObject;
    }

    private static List<Object> convertToGenericObjects(String type, Iterable<Object> params) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object param : params) {
            list.add(SofaParamResolveServiceImpl.convertToGenericObject(type, param));
        }
        return list;
    }

    private static boolean isSingleType(String[] parameter) {
        return parameter.length == 1 && SofaParamResolveServiceImpl.isSingleType(parameter[0]);
    }

    private static boolean isSingleType(String parameterType) {
        return parameterType.startsWith("java");
    }
}

