/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register.registrar;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.registrar.AbstractApiDocRegistrar;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public final class HttpApiDocRegistrar
extends AbstractApiDocRegistrar {
    public HttpApiDocRegistrar(ShenyuClientRegisterEventPublisher publisher, ClientRegisterConfig clientRegisterConfig) {
        super(publisher, clientRegisterConfig);
    }

    @Override
    protected AbstractApiDocRegistrar.HttpApiSpecificInfo doParse(ApiBean.ApiDefinition apiDefinition) {
        RequestMapping requestMapping = apiDefinition.getAnnotation(RequestMapping.class);
        String produce = requestMapping.produces().length == 0 ? "*/*" : String.join((CharSequence)",", requestMapping.produces());
        String consume = requestMapping.consumes().length == 0 ? "*/*" : String.join((CharSequence)",", requestMapping.consumes());
        RequestMethod[] requestMethods = requestMapping.method();
        if (requestMethods.length == 0) {
            requestMethods = RequestMethod.values();
        }
        List<ApiHttpMethodEnum> apiHttpMethodEnums = Stream.of(requestMethods).map(item -> ApiHttpMethodEnum.of((String)item.name())).collect(Collectors.toList());
        return new AbstractApiDocRegistrar.HttpApiSpecificInfo(produce, consume, apiHttpMethodEnums);
    }
}

