/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register.registrar;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.registrar.BaseApiRegistrarImpl;
import org.apache.shenyu.client.core.utils.ApiBeanUtil;
import org.apache.shenyu.client.core.utils.OpenApiUtils;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.ApiSourceEnum;
import org.apache.shenyu.common.enums.ApiStateEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.PathUtils;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.jetbrains.annotations.NotNull;

public class ApiDocRegistrarImpl
extends BaseApiRegistrarImpl {
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final ClientRegisterConfig clientRegisterConfig;

    public ApiDocRegistrarImpl(ClientRegisterConfig clientRegisterConfig) {
        this.clientRegisterConfig = clientRegisterConfig;
    }

    @Override
    protected void doRegisterBean(ApiBean apiBean) {
    }

    @Override
    protected void doRegisterApi(ApiBean.ApiDefinition api) {
        this.publisher.publishEvent((DataTypeParent)ApiDocRegisterDTO.builder().consume(ApiDocRegistrarImpl.getConsume(api)).produce(this.getProduce(api)).httpMethod(ApiDocRegistrarImpl.getHttpMethod(api)).contextPath(this.clientRegisterConfig.getContextPath()).document(this.getDocument(api)).rpcType(this.getRpcType(api)).version(this.getVersion(api)).apiDesc(this.getApiDesc(api)).ext(this.getExt(api)).tags(this.buildTags(api)).apiPath(this.getPath(api)).apiSource(this.getApiSource(api)).apiOwner(ApiDocRegistrarImpl.getOwner(api)).state(Integer.valueOf(ApiStateEnum.PUBLISHED.getState())).eventType(EventType.REGISTER).build());
    }

    private static Integer getHttpMethod(ApiBean.ApiDefinition api) {
        String httpMethod = api.getPropertiesValue("httpMethod");
        if (StringUtils.isNotBlank((CharSequence)httpMethod)) {
            return Integer.parseInt(httpMethod);
        }
        return ApiHttpMethodEnum.NOT_HTTP.getValue();
    }

    @NotNull
    private static String getOwner(ApiBean.ApiDefinition api) {
        String owner = api.getPropertiesValue("owner");
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            return owner;
        }
        return "admin";
    }

    private String getExt(ApiBean.ApiDefinition api) {
        String ext = api.getPropertiesValue("ext");
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            return ext;
        }
        ApiDocRegisterDTO.ApiExt apiExt = new ApiDocRegisterDTO.ApiExt();
        apiExt.setHost(this.clientRegisterConfig.getHost());
        apiExt.setPort(this.clientRegisterConfig.getPort());
        apiExt.setServiceName(api.getApiBean().getBeanClass().getName());
        apiExt.setMethodName(api.getApiMethodName());
        apiExt.setParameterTypes(api.getParameterTypes());
        apiExt.setRpcExt(api.getPropertiesValue("RpcExt"));
        apiExt.setAddPrefixed(this.clientRegisterConfig.getAddPrefixed().booleanValue());
        String rpcType = this.getRpcType(api);
        if (Objects.equals(rpcType, RpcTypeEnum.HTTP.getName())) {
            apiExt.setProtocol("http://");
        }
        if (Objects.equals(rpcType, RpcTypeEnum.WEB_SOCKET.getName())) {
            apiExt.setProtocol("ws://");
        }
        return GsonUtils.getInstance().toJson((Object)apiExt);
    }

    private String getDocument(ApiBean.ApiDefinition api) {
        String document = api.getPropertiesValue("document");
        if (StringUtils.isNotBlank((CharSequence)document)) {
            return document;
        }
        String path = this.getPath(api);
        ImmutableMap documentMap = ImmutableMap.builder().put((Object)"tags", this.buildTags(api)).put((Object)"operationId", (Object)path).put((Object)"parameters", OpenApiUtils.generateDocumentParameters(path, api.getApiMethod())).put((Object)"responses", OpenApiUtils.generateDocumentResponse(path)).put((Object)"responseType", Collections.singletonList(OpenApiUtils.parseReturnType(api.getApiMethod()))).build();
        return GsonUtils.getInstance().toJson((Object)documentMap);
    }

    private String getRpcType(ApiBean.ApiDefinition api) {
        return ApiBeanUtil.getRpcType(api);
    }

    private String getVersion(ApiBean.ApiDefinition api) {
        String version = api.getPropertiesValue("version");
        if (StringUtils.isNotBlank((CharSequence)version)) {
            return version;
        }
        return "v0.01";
    }

    private String getApiDesc(ApiBean.ApiDefinition api) {
        String desc = api.getPropertiesValue("desc");
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            return desc;
        }
        return api.getApiBean().getClientName() + ":" + api.getApiBean().getBeanClass().getName() + "#" + api.getApiMethod().getName();
    }

    private Integer getApiSource(ApiBean.ApiDefinition apiDefinition) {
        String apiSource = apiDefinition.getPropertiesValue("apiSource");
        if (StringUtils.isNotBlank((CharSequence)apiSource)) {
            return Integer.parseInt(apiSource);
        }
        return ApiSourceEnum.ANNOTATION_GENERATION.getValue();
    }

    private String getPath(ApiBean.ApiDefinition api) {
        return PathUtils.pathJoin((String[])new String[]{this.clientRegisterConfig.getContextPath(), api.getApiBean().getBeanPath(), api.getMethodPath()});
    }

    private String getProduce(ApiBean.ApiDefinition api) {
        String produce = api.getPropertiesValue("produce");
        if (StringUtils.isBlank((CharSequence)produce)) {
            return "*/*";
        }
        return produce;
    }

    private static String getConsume(ApiBean.ApiDefinition api) {
        String consume = api.getPropertiesValue("consume");
        if (StringUtils.isBlank((CharSequence)consume)) {
            return "*/*";
        }
        return consume;
    }

    private List<String> buildTags(ApiBean.ApiDefinition api) {
        String tags = api.getPropertiesValue("tags");
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            return Arrays.stream(tags.split(",")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

