/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.net.core.nio;

import com.qq.tars.net.core.IoBuffer;
import com.qq.tars.net.core.Request;
import com.qq.tars.net.core.Response;
import com.qq.tars.net.core.Session;
import com.qq.tars.net.core.SessionManager;
import com.qq.tars.net.core.nio.Reactor;
import com.qq.tars.net.core.nio.SelectorManager;
import com.qq.tars.net.core.nio.WorkThread;
import com.qq.tars.net.protocol.ProtocolException;
import com.qq.tars.net.protocol.ProtocolFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class TCPSession
extends Session {
    private SelectionKey key = null;
    private SelectableChannel channel = null;
    private SelectorManager selectorManager = null;
    private int bufferSize = 4096;
    private IoBuffer readBuffer = null;
    private boolean tcpNoDelay = false;
    private Queue<ByteBuffer> queue = new LinkedBlockingQueue<ByteBuffer>(8192);
    private static final AtomicInteger hashCodeGenerator = new AtomicInteger();
    private int hashCode = 0;

    public TCPSession(SelectorManager selectorManager) {
        this.selectorManager = selectorManager;
        this.hashCode = hashCodeGenerator.incrementAndGet();
    }

    @Override
    public void asyncClose() throws IOException {
        if (this.key == null) {
            return;
        }
        Reactor reactor = this.selectorManager.getReactor(this.key);
        if (reactor == null) {
            throw new IOException("failed to find the selector for this session.");
        }
        reactor.unRegisterChannel(this);
    }

    @Override
    public void close() throws IOException {
        if (this.status == Session.SessionStatus.CLOSED) {
            return;
        }
        this.status = Session.SessionStatus.CLOSED;
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.key != null) {
                this.key.cancel();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.key = null;
        this.channel = null;
        SessionManager.getSessionManager().unregisterSession(this);
    }

    @Override
    protected void read() throws IOException {
        int ret = this.readChannel();
        if (this.status == Session.SessionStatus.CLIENT_CONNECTED) {
            this.readResponse();
        } else if (this.status == Session.SessionStatus.SERVER_CONNECTED) {
            this.readRequest();
        } else {
            throw new IllegalStateException("The current session status is invalid. [status:" + (Object)((Object)this.status) + "]");
        }
        if (ret < 0) {
            this.close();
            return;
        }
    }

    public void readRequest() throws IOException {
        Request request = null;
        IoBuffer tempBuffer = null;
        try {
            tempBuffer = this.readBuffer.duplicate().flip();
            while (true) {
                tempBuffer.mark();
                request = tempBuffer.remaining() > 0 ? this.selectorManager.getProtocolFactory().getDecoder().decodeRequest(tempBuffer, this) : null;
                if (request == null) break;
                try {
                    request.resetBornTime();
                    this.selectorManager.getThreadPool().execute(new WorkThread(request, this.selectorManager));
                }
                catch (RejectedExecutionException e) {
                    this.selectorManager.getProcessor().overload(request, request.getIoSession());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            tempBuffer.reset();
            this.readBuffer = this.resetIoBuffer(tempBuffer);
        }
        catch (ProtocolException ex) {
            this.close();
            ex.printStackTrace();
        }
    }

    public void readResponse() throws IOException {
        Response response = null;
        IoBuffer tempBuffer = null;
        try {
            tempBuffer = this.readBuffer.duplicate().flip();
            while (true) {
                tempBuffer.mark();
                response = tempBuffer.remaining() > 0 ? this.selectorManager.getProtocolFactory().getDecoder().decodeResponse(tempBuffer, this) : null;
                if (response == null) break;
                try {
                    if (response.getTicketNumber() == -1) {
                        response.setTicketNumber(response.getSession().hashCode());
                    }
                    this.selectorManager.getThreadPool().execute(new WorkThread(response, this.selectorManager));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            tempBuffer.reset();
            this.readBuffer = this.resetIoBuffer(tempBuffer);
        }
        catch (ProtocolException ex) {
            this.close();
            ex.printStackTrace();
        }
    }

    @Override
    public void write(Request request) throws IOException {
        try {
            IoBuffer buffer = this.selectorManager.getProtocolFactory().getEncoder().encodeRequest(request, this);
            this.write(buffer);
        }
        catch (ProtocolException ex) {
            throw new IOException("protocol error:", ex);
        }
    }

    @Override
    public void write(Response response) throws IOException {
        try {
            IoBuffer buffer = this.selectorManager.getProtocolFactory().getEncoder().encodeResponse(response, this);
            this.write(buffer);
        }
        catch (ProtocolException ex) {
            throw new IOException("protocol error:", ex);
        }
    }

    @Override
    public String getRemoteIp() {
        if (this.status != Session.SessionStatus.CLOSED) {
            return ((SocketChannel)this.channel).socket().getInetAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        if (this.status != Session.SessionStatus.CLOSED) {
            return ((SocketChannel)this.channel).socket().getPort();
        }
        return -1;
    }

    @Override
    public void accept() throws IOException {
    }

    protected void write(IoBuffer buffer) throws IOException {
        if (buffer == null) {
            return;
        }
        if (this.channel == null || this.key == null) {
            throw new IOException("Connection is closed");
        }
        if (!this.queue.offer(buffer.buf())) {
            throw new IOException("The session queue is full. [ queue size:" + this.queue.size() + " ]");
        }
        if (this.key != null) {
            this.key.interestOps(this.key.interestOps() | 4);
            this.key.selector().wakeup();
        }
    }

    protected synchronized int doWrite() throws IOException {
        int writeBytes;
        block5: {
            writeBytes = 0;
            while (true) {
                ByteBuffer wBuf;
                if ((wBuf = this.queue.peek()) == null) {
                    this.key.interestOps(1);
                    if (this.queue.peek() != null) {
                        this.key.interestOps(5);
                    }
                    this.key.selector().wakeup();
                    break block5;
                }
                int bytesWritten = ((SocketChannel)this.channel).write(wBuf);
                if (bytesWritten == 0 && wBuf.remaining() > 0) {
                    this.key.interestOps(5);
                    this.key.selector().wakeup();
                    break block5;
                }
                if (wBuf.remaining() != 0) break;
                ++writeBytes;
                this.queue.remove();
            }
            return -1;
        }
        if (!this.isKeepAlive()) {
            this.close();
        }
        return writeBytes;
    }

    protected IoBuffer resetIoBuffer(IoBuffer buffer) {
        IoBuffer newBuffer = null;
        if (buffer != null && buffer.remaining() > 0) {
            int len = buffer.remaining();
            byte[] bb = new byte[len];
            buffer.get(bb);
            newBuffer = IoBuffer.wrap(bb);
            newBuffer.position(len);
        }
        return newBuffer;
    }

    public SelectionKey getKey() {
        return this.key;
    }

    public void setKey(SelectionKey key) {
        this.key = key;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean on) {
        this.tcpNoDelay = on;
    }

    public SelectableChannel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(SelectableChannel channel) {
        this.channel = channel;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.selectorManager.getProtocolFactory();
    }

    private int readChannel() throws IOException {
        int readBytes = 0;
        int ret = 0;
        ByteBuffer data = ByteBuffer.allocate(2048);
        if (this.readBuffer == null) {
            this.readBuffer = IoBuffer.allocate(this.bufferSize);
        }
        while ((ret = ((SocketChannel)this.channel).read(data)) > 0) {
            data.flip();
            readBytes += data.remaining();
            this.readBuffer.put(data.array(), data.position(), data.remaining());
            data.clear();
        }
        return ret < 0 ? ret : readBytes;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

