/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache.memory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.plugin.cache.ICache;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class MemoryCache
implements ICache {
    private final Map<String, Cache<String, byte[]>> mainCache = new ConcurrentHashMap<String, Cache<String, byte[]>>();

    public Mono<Boolean> cacheData(String key, byte[] bytes, long timeoutSeconds) {
        Cache cache = CacheBuilder.newBuilder().expireAfterWrite(timeoutSeconds, TimeUnit.SECONDS).build();
        cache.put((Object)key, (Object)bytes);
        this.mainCache.put(key, (Cache<String, byte[]>)cache);
        return Mono.fromCallable(() -> Boolean.TRUE).subscribeOn(Schedulers.boundedElastic());
    }

    public Mono<Boolean> isExist(String key) {
        Cache<String, byte[]> cache = this.mainCache.get(key);
        if (Objects.isNull(cache) || !cache.asMap().containsKey(key)) {
            this.mainCache.remove(key);
            return Mono.fromCallable(() -> Boolean.FALSE).subscribeOn(Schedulers.boundedElastic());
        }
        return Mono.fromCallable(() -> Boolean.TRUE).subscribeOn(Schedulers.boundedElastic());
    }

    public Mono<byte[]> getData(String key) {
        return this.isExist(key).mapNotNull(exist -> {
            if (exist.booleanValue()) {
                return (byte[])this.mainCache.get(key).asMap().get(key);
            }
            return null;
        });
    }

    public void close() {
        this.mainCache.clear();
    }
}

