/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport.http;

import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.codec.Serializer;
import com.alipay.sofa.rpc.codec.SerializerFactory;
import com.alipay.sofa.rpc.codec.common.StringSerializer;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.AsyncRuntime;
import com.alipay.sofa.rpc.context.BaggageResolver;
import com.alipay.sofa.rpc.context.RpcInternalContext;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.context.RpcRuntimeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ClientHandler;
import com.alipay.sofa.rpc.transport.http.HttpTransportUtils;
import com.alipay.sofa.rpc.transport.netty.NettyByteBuffer;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.HashMap;
import java.util.concurrent.Executor;

public abstract class AbstractHttpClientHandler
implements ClientHandler {
    protected final ConsumerConfig consumerConfig;
    protected final ProviderInfo providerInfo;
    protected final SofaRequest request;
    protected ClassLoader classLoader;
    protected RpcInternalContext context;

    protected AbstractHttpClientHandler(ConsumerConfig consumerConfig, ProviderInfo providerInfo, SofaRequest request, RpcInternalContext context, ClassLoader classLoader) {
        this.consumerConfig = consumerConfig;
        this.providerInfo = providerInfo;
        this.request = request;
        this.context = context;
        this.classLoader = classLoader;
    }

    protected void recordClientElapseTime() {
        Long startTime;
        if (this.context != null && (startTime = (Long)this.context.removeAttachment("_client_send_time")) != null) {
            this.context.setAttachment("_client_elapse", RpcRuntimeContext.now() - startTime);
        }
    }

    protected void pickupBaggage(SofaResponse response) {
        if (RpcInvokeContext.isBaggageEnable()) {
            RpcInvokeContext invokeCtx = null;
            if (this.context != null) {
                invokeCtx = (RpcInvokeContext)this.context.getAttachment(".invoke_ctx");
            }
            if (invokeCtx == null) {
                invokeCtx = RpcInvokeContext.getContext();
            } else {
                RpcInvokeContext.setContext(invokeCtx);
                invokeCtx = RpcInvokeContext.getContext();
            }
            BaggageResolver.pickupFromResponse(invokeCtx, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(SofaResponse response) {
        AbstractByteBuf byteBuffer = response.getData();
        if (byteBuffer != null) {
            try {
                HashMap<String, String> context = new HashMap<String, String>(4);
                if (response.isError()) {
                    context.put("sofa_head_response_error", response.isError() + "");
                    String errorMsg = StringSerializer.decode(byteBuffer.array());
                    response.setAppResponse(new SofaRpcException(199, errorMsg));
                } else {
                    context.put("sofa_head_target_service", this.request.getTargetServiceUniqueName());
                    context.put("sofa_head_method_name", this.request.getMethodName());
                    Serializer serializer = SerializerFactory.getSerializer(response.getSerializeType());
                    serializer.decode(byteBuffer, response, context);
                }
            }
            finally {
                byteBuffer.release();
                response.setData(null);
            }
        }
    }

    @Override
    public Executor getExecutor() {
        return AsyncRuntime.getAsyncThreadPool();
    }

    public void receiveHttpResponse(FullHttpResponse msg) {
        HttpHeaders headers = msg.headers();
        ByteBuf content = msg.content();
        NettyByteBuffer data = new NettyByteBuffer(content);
        try {
            if (msg.status() == HttpResponseStatus.OK) {
                SofaResponse response = new SofaResponse();
                String isError = headers.get("sofa_head_response_error");
                if (CommonUtils.isTrue(isError)) {
                    String errorMsg = StringSerializer.decode(data.array());
                    SofaRpcException throwable = new SofaRpcException(160, errorMsg);
                    response.setAppResponse(throwable);
                } else if (data.readableBytes() > 0) {
                    byte serializeType;
                    String codeName = headers.get("sofa_head_serialize_type");
                    if (codeName != null) {
                        serializeType = HttpTransportUtils.getSerializeTypeByName(codeName);
                    } else {
                        String contentType = StringUtils.toString(headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
                        serializeType = HttpTransportUtils.getSerializeTypeByContentType(contentType);
                    }
                    response.setSerializeType(serializeType);
                    content.retain();
                    response.setData(data);
                }
                this.onResponse(response);
            } else {
                String errorMsg = StringSerializer.decode(data.array());
                SofaRpcException throwable = new SofaRpcException(199, errorMsg);
                this.onException(throwable);
            }
        }
        catch (Exception e) {
            this.onException(e);
        }
    }

    public abstract void doOnResponse(Object var1);

    public abstract void doOnException(Throwable var1);

    @Override
    public void onResponse(final Object response) {
        Executor executor = this.getExecutor();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractHttpClientHandler.this.doOnResponse(response);
                }
            });
        } else {
            this.doOnResponse(response);
        }
    }

    @Override
    public void onException(final Throwable e) {
        Executor executor = this.getExecutor();
        if (executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractHttpClientHandler.this.doOnException(e);
                }
            });
        } else {
            this.doOnException(e);
        }
    }
}

