/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.polaris;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.polaris.PolarisRegistryProperties;
import com.alipay.sofa.rpc.registry.utils.RegistryUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.rpc.GetAllInstancesRequest;
import com.tencent.polaris.api.rpc.InstancesResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PolarisWatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolarisWatcher.class);
    private String nameSpace;
    private String serviceName;
    private String protocol;
    private InstancesResponse currentData;
    private ConsumerAPI consumerAPI;
    private PolarisRegistryProperties properties;
    private List<ProviderInfoListener> listeners;
    private ScheduledExecutorService watchExecutor;

    public PolarisWatcher(String nameSpace, String serviceName, String protocol, ConsumerAPI consumerAPI, PolarisRegistryProperties properties) {
        this.nameSpace = nameSpace;
        this.serviceName = serviceName;
        this.protocol = protocol;
        this.consumerAPI = consumerAPI;
        this.properties = properties;
        this.listeners = new ArrayList<ProviderInfoListener>();
    }

    private void watchService() {
        try {
            InstancesResponse response;
            GetAllInstancesRequest getAllInstancesRequest = new GetAllInstancesRequest();
            getAllInstancesRequest.setNamespace(this.nameSpace);
            getAllInstancesRequest.setService(this.serviceName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("protocol", this.protocol);
            getAllInstancesRequest.setMetadata(parameters);
            this.currentData = response = this.consumerAPI.getAllInstance(getAllInstancesRequest);
            ProviderGroup providerGroup = new ProviderGroup(this.currentProviders());
            this.listeners.stream().filter(Objects::nonNull).forEach(l -> l.updateProviders(providerGroup));
        }
        catch (Exception e) {
            LOGGER.error(LogCodes.getLog("010060025", "Polaris"), e);
        }
    }

    public List<ProviderInfo> currentProviders() {
        Instance[] instances;
        ArrayList<ProviderInfo> providerInfos = new ArrayList<ProviderInfo>();
        for (Instance instance : instances = this.currentData.getInstances()) {
            ProviderInfo providerInfo = ProviderHelper.toProviderInfo(RegistryUtils.convertInstanceToUrl(instance.getHost(), instance.getPort(), this.currentData.getMetadata()));
            providerInfos.add(providerInfo);
        }
        return providerInfos;
    }

    public void init() {
        GetAllInstancesRequest getAllInstancesRequest = new GetAllInstancesRequest();
        getAllInstancesRequest.setNamespace(this.nameSpace);
        getAllInstancesRequest.setService(this.serviceName);
        this.currentData = this.consumerAPI.getAllInstance(getAllInstancesRequest);
        this.watchExecutor = Executors.newSingleThreadScheduledExecutor();
        this.watchExecutor.scheduleWithFixedDelay(this::watchService, this.properties.getLookupInterval(), this.properties.getLookupInterval(), TimeUnit.MILLISECONDS);
    }

    public void addListener(ProviderInfoListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ProviderInfoListener listener) {
        this.listeners.remove(listener);
    }

    public int getListenerSize() {
        return this.listeners.size();
    }

    public void shutdown() {
        this.watchExecutor.shutdown();
    }
}

