/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.fury.serialize;

import com.alipay.sofa.rpc.codec.CustomSerializer;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import io.fury.ThreadSafeFury;
import io.fury.memory.MemoryBuffer;
import java.util.Map;

public class SofaRequestFurySerializer
implements CustomSerializer<SofaRequest> {
    private final ThreadSafeFury fury;

    public SofaRequestFurySerializer(ThreadSafeFury fury) {
        this.fury = fury;
    }

    @Override
    public AbstractByteBuf encodeObject(SofaRequest object, Map<String, String> context) throws SofaRpcException {
        try {
            boolean genericSerialize;
            MemoryBuffer writeBuffer = MemoryBuffer.newHeapBuffer((int)32);
            writeBuffer.writerIndex(0);
            boolean bl = genericSerialize = context != null && this.isGenericRequest(context.get("sofa_head_generic_type"));
            if (genericSerialize) {
                throw new SofaRpcException(220, "Generic call is not supported for now.");
            }
            this.fury.serialize(writeBuffer, (Object)object);
            Object[] args = object.getMethodArgs();
            this.fury.serialize(writeBuffer, (Object)args);
            return new ByteArrayWrapperByteBuf(writeBuffer.getBytes(0, writeBuffer.writerIndex()));
        }
        catch (Exception e) {
            throw new SofaRpcException(220, e.getMessage(), e);
        }
    }

    @Override
    public SofaRequest decodeObject(AbstractByteBuf data, Map<String, String> context) throws SofaRpcException {
        MemoryBuffer readBuffer = MemoryBuffer.fromByteArray((byte[])data.array());
        try {
            SofaRequest sofaRequest = (SofaRequest)this.fury.deserialize(readBuffer);
            String targetServiceName = sofaRequest.getTargetServiceUniqueName();
            if (targetServiceName == null) {
                throw new SofaRpcException(130, "Target service name of request is null!");
            }
            String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetServiceName);
            sofaRequest.setInterfaceName(interfaceName);
            Object[] args = (Object[])this.fury.deserialize(readBuffer);
            sofaRequest.setMethodArgs(args);
            return sofaRequest;
        }
        catch (Exception e) {
            throw new SofaRpcException(130, e.getMessage(), e);
        }
    }

    @Override
    public void decodeObjectByTemplate(AbstractByteBuf data, Map<String, String> context, SofaRequest template) throws SofaRpcException {
        if (data.readableBytes() <= 0) {
            throw new SofaRpcException(130, "Deserialized array is empty.");
        }
        try {
            MemoryBuffer readBuffer = MemoryBuffer.fromByteArray((byte[])data.array());
            SofaRequest tmp = (SofaRequest)this.fury.deserialize(readBuffer);
            String targetServiceName = tmp.getTargetServiceUniqueName();
            if (targetServiceName == null) {
                throw new SofaRpcException(130, "Target service name of request is null!");
            }
            template.setMethodName(tmp.getMethodName());
            template.setMethodArgSigs(tmp.getMethodArgSigs());
            template.setTargetServiceUniqueName(tmp.getTargetServiceUniqueName());
            template.setTargetAppName(tmp.getTargetAppName());
            template.addRequestProps(tmp.getRequestProps());
            String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetServiceName);
            template.setInterfaceName(interfaceName);
            Object[] args = (Object[])this.fury.deserialize(readBuffer);
            template.setMethodArgs(args);
        }
        catch (Exception e) {
            throw new SofaRpcException(130, e.getMessage(), e);
        }
    }

    protected boolean isGenericRequest(String serializeType) {
        return serializeType != null && !serializeType.equals("0");
    }
}

