/*
 * Decompiled with CFR 0.152.
 */
package io.fury.type;

import com.google.common.reflect.TypeToken;
import io.fury.Fury;
import io.fury.collection.IdentityObjectIntMap;
import io.fury.memory.MemoryBuffer;
import io.fury.memory.MemoryUtils;
import io.fury.resolver.ClassResolver;
import io.fury.type.Descriptor;
import io.fury.type.DescriptorGrouper;
import io.fury.type.FinalObjectTypeStub;
import io.fury.type.GenericType;
import io.fury.type.TypeUtils;
import io.fury.util.LoggerFactory;
import io.fury.util.MurmurHash3;
import io.fury.util.Platform;
import io.fury.util.Preconditions;
import io.fury.util.ReflectionUtils;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;

public class ClassDef
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ClassDef.class);
    public static final Comparator<Field> FIELD_COMPARATOR = (f1, f2) -> {
        int compare;
        long offset2;
        long offset1 = Platform.objectFieldOffset(f1);
        long diff = offset1 - (offset2 = Platform.objectFieldOffset(f2));
        if (diff != 0L) {
            return (int)diff;
        }
        if (!f1.equals(f2)) {
            LOG.warn("Field {} has same offset with {}, please an issue with jdk info to fury", f1, f2);
        }
        if ((compare = f1.getDeclaringClass().getName().compareTo(f2.getName())) != 0) {
            return compare;
        }
        return f1.getName().compareTo(f2.getName());
    };
    private final String className;
    private final List<FieldInfo> fieldsInfo;
    private final Map<String, String> extMeta;
    private long id;
    private transient byte[] serialized;

    private ClassDef(String className, List<FieldInfo> fieldsInfo, Map<String, String> extMeta) {
        this.className = className;
        this.fieldsInfo = fieldsInfo;
        this.extMeta = extMeta;
    }

    public String getClassName() {
        return this.className;
    }

    public List<FieldInfo> getFieldsInfo() {
        return this.fieldsInfo;
    }

    public Map<String, String> getExtMeta() {
        return this.extMeta;
    }

    public long getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassDef classDef = (ClassDef)o;
        return Objects.equals(this.className, classDef.className) && Objects.equals(this.fieldsInfo, classDef.fieldsInfo) && Objects.equals(this.extMeta, classDef.extMeta);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.fieldsInfo, this.extMeta);
    }

    public void writeClassDef(MemoryBuffer buffer) {
        byte[] serialized = this.serialized;
        if (serialized == null) {
            MemoryBuffer buf = MemoryUtils.buffer(32);
            IdentityObjectIntMap<String> map = new IdentityObjectIntMap<String>(8, 0.5f);
            ClassDef.writeSharedString(buf, map, this.className);
            buf.writePositiveVarInt(this.fieldsInfo.size());
            for (FieldInfo fieldInfo : this.fieldsInfo) {
                ClassDef.writeSharedString(buf, map, fieldInfo.definedClass);
                byte[] bytes = fieldInfo.fieldName.getBytes(StandardCharsets.UTF_8);
                buf.writePrimitiveArrayWithSizeEmbedded(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length);
                fieldInfo.fieldType.write(buf);
            }
            buf.writePositiveVarInt(this.extMeta.size());
            this.extMeta.forEach((k, v) -> {
                byte[] keyBytes = k.getBytes(StandardCharsets.UTF_8);
                byte[] valueBytes = v.getBytes(StandardCharsets.UTF_8);
                buf.writePrimitiveArrayWithSizeEmbedded(keyBytes, Platform.BYTE_ARRAY_OFFSET, keyBytes.length);
                buf.writePrimitiveArrayWithSizeEmbedded(valueBytes, Platform.BYTE_ARRAY_OFFSET, valueBytes.length);
            });
            serialized = this.serialized = buf.getBytes(0, buf.writerIndex());
            this.id = MurmurHash3.murmurhash3_x64_128(serialized, 0, serialized.length, 47)[0];
            this.id = Math.abs(this.id);
        }
        buffer.writeBytes(serialized);
        buffer.writeLong(this.id);
    }

    private static void writeSharedString(MemoryBuffer buffer, IdentityObjectIntMap<String> map, String str) {
        int newId = map.size;
        int id = map.putOrGet(str, newId);
        if (id >= 0) {
            buffer.writeBoolean(true);
            buffer.writePositiveVarInt(id);
        } else {
            buffer.writeBoolean(false);
            byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
            buffer.writePrimitiveArrayWithSizeEmbedded(bytes, Platform.BYTE_ARRAY_OFFSET, bytes.length);
        }
    }

    public static ClassDef readClassDef(MemoryBuffer buffer) {
        ArrayList<String> strings = new ArrayList<String>();
        String className = ClassDef.readSharedString(buffer, strings);
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        int numFields = buffer.readPositiveVarInt();
        for (int i = 0; i < numFields; ++i) {
            String definedClass = ClassDef.readSharedString(buffer, strings);
            String fieldName = new String(buffer.readBytesWithSizeEmbedded(), StandardCharsets.UTF_8);
            fieldInfos.add(new FieldInfo(definedClass, fieldName, FieldType.read(buffer)));
        }
        int extMetaSize = buffer.readPositiveVarInt();
        HashMap<String, String> extMeta = new HashMap<String, String>();
        for (int i = 0; i < extMetaSize; ++i) {
            extMeta.put(new String(buffer.readBytesWithSizeEmbedded(), StandardCharsets.UTF_8), new String(buffer.readBytesWithSizeEmbedded(), StandardCharsets.UTF_8));
        }
        long id = buffer.readLong();
        ClassDef classDef = new ClassDef(className, fieldInfos, extMeta);
        classDef.id = id;
        return classDef;
    }

    private static String readSharedString(MemoryBuffer buffer, List<String> strings) {
        if (buffer.readBoolean()) {
            return strings.get(buffer.readPositiveVarInt());
        }
        String str = new String(buffer.readBytesWithSizeEmbedded(), StandardCharsets.UTF_8);
        strings.add(str);
        return str;
    }

    public static ClassDef buildClassDef(Class<?> cls, Fury fury) {
        Comparator<Descriptor> comparator = DescriptorGrouper.getPrimitiveComparator(fury.compressInt(), fury.compressLong());
        DescriptorGrouper descriptorGrouper = new DescriptorGrouper(fury.getClassResolver().getAllDescriptorsMap(cls, true).values(), false, Function.identity(), comparator, DescriptorGrouper.COMPARATOR_BY_TYPE_AND_NAME);
        ClassResolver classResolver = fury.getClassResolver();
        ArrayList<Field> fields = new ArrayList<Field>();
        descriptorGrouper.getPrimitiveDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getBoxedDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getFinalDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getOtherDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getCollectionDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        descriptorGrouper.getMapDescriptors().forEach(descriptor -> fields.add(descriptor.getField()));
        return ClassDef.buildClassDef(classResolver, cls, fields);
    }

    public static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields) {
        return ClassDef.buildClassDef(classResolver, type, fields, new HashMap<String, String>());
    }

    public static ClassDef buildClassDef(ClassResolver classResolver, Class<?> type, List<Field> fields, Map<String, String> extMeta) {
        ArrayList<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
        for (Field field : fields) {
            FieldInfo fieldInfo = new FieldInfo(field.getDeclaringClass().getName(), field.getName(), ClassDef.buildFieldType(classResolver, field));
            fieldInfos.add(fieldInfo);
        }
        return new ClassDef(type.getName(), fieldInfos, extMeta);
    }

    static FieldType buildFieldType(ClassResolver classResolver, Field field) {
        Preconditions.checkNotNull(field);
        Class<?> rawType = field.getType();
        boolean isFinal = GenericType.defaultFinalPredicate.test(rawType);
        if (Collection.class.isAssignableFrom(rawType)) {
            GenericType genericType = GenericType.build(field.getGenericType());
            return new CollectionFieldType(isFinal, ClassDef.buildFieldType(classResolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            GenericType genericType = GenericType.build(field.getGenericType());
            return new MapFieldType(isFinal, ClassDef.buildFieldType(classResolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()), ClassDef.buildFieldType(classResolver, genericType.getTypeParameter1() == null ? GenericType.build(Object.class) : genericType.getTypeParameter1()));
        }
        Short classId = classResolver.getRegisteredClassId(rawType);
        if (classId != null && classId != 0) {
            return new RegisteredFieldType(isFinal, classId);
        }
        return new ObjectFieldType(isFinal);
    }

    private static FieldType buildFieldType(ClassResolver classResolver, GenericType genericType) {
        Preconditions.checkNotNull(genericType);
        boolean isFinal = genericType.isFinal();
        if (TypeUtils.COLLECTION_TYPE.isSupertypeOf(genericType.typeToken)) {
            return new CollectionFieldType(isFinal, ClassDef.buildFieldType(classResolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()));
        }
        if (TypeUtils.MAP_TYPE.isSupertypeOf(genericType.typeToken)) {
            return new MapFieldType(isFinal, ClassDef.buildFieldType(classResolver, genericType.getTypeParameter0() == null ? GenericType.build(Object.class) : genericType.getTypeParameter0()), ClassDef.buildFieldType(classResolver, genericType.getTypeParameter1() == null ? GenericType.build(Object.class) : genericType.getTypeParameter1()));
        }
        Short classId = classResolver.getRegisteredClassId(genericType.cls);
        if (classId != null && classId != 0) {
            return new RegisteredFieldType(isFinal, classId);
        }
        return new ObjectFieldType(isFinal);
    }

    public static class FieldInfo
    implements Serializable {
        private final String definedClass;
        private final String fieldName;
        private final FieldType fieldType;

        private FieldInfo(String definedClass, String fieldName, FieldType fieldType) {
            this.definedClass = definedClass;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
        }

        public String getDefinedClass() {
            return this.definedClass;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public FieldType getFieldType() {
            return this.fieldType;
        }

        public Descriptor toDescriptor(ClassResolver classResolver) {
            TypeToken<?> typeToken = this.fieldType.toTypeToken(classResolver);
            int stubModifiers = ReflectionUtils.getField(this.getClass(), "fieldName").getModifiers();
            return new Descriptor(typeToken, this.fieldName, stubModifiers, this.definedClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldInfo fieldInfo = (FieldInfo)o;
            return Objects.equals(this.definedClass, fieldInfo.definedClass) && Objects.equals(this.fieldName, fieldInfo.fieldName) && Objects.equals(this.fieldType, fieldInfo.fieldType);
        }

        public int hashCode() {
            return Objects.hash(this.definedClass, this.fieldName, this.fieldType);
        }

        public String toString() {
            return "FieldInfo{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
        }
    }

    public static abstract class FieldType
    implements Serializable {
        private final boolean isFinal;

        public FieldType(boolean isFinal) {
            this.isFinal = isFinal;
        }

        public boolean isFinal() {
            return this.isFinal;
        }

        public abstract TypeToken<?> toTypeToken(ClassResolver var1);

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldType fieldType = (FieldType)o;
            return this.isFinal == fieldType.isFinal;
        }

        public int hashCode() {
            return Objects.hash(this.isFinal);
        }

        public void write(MemoryBuffer buffer) {
            buffer.writeBoolean(this.isFinal);
            if (this instanceof RegisteredFieldType) {
                buffer.writeByte(0);
                buffer.writeShort(((RegisteredFieldType)this).getClassId());
            } else if (this instanceof CollectionFieldType) {
                buffer.writeByte(1);
                ((CollectionFieldType)this).elementType.write(buffer);
            } else if (this instanceof MapFieldType) {
                buffer.writeByte(2);
                MapFieldType mapFieldType = (MapFieldType)this;
                mapFieldType.keyType.write(buffer);
                mapFieldType.valueType.write(buffer);
            } else {
                Preconditions.checkArgument(this instanceof ObjectFieldType);
                buffer.writeByte(3);
            }
        }

        public static FieldType read(MemoryBuffer buffer) {
            boolean isFinal = buffer.readBoolean();
            byte typecode = buffer.readByte();
            switch (typecode) {
                case 0: {
                    return new RegisteredFieldType(isFinal, buffer.readShort());
                }
                case 1: {
                    return new CollectionFieldType(isFinal, FieldType.read(buffer));
                }
                case 2: {
                    return new MapFieldType(isFinal, FieldType.read(buffer), FieldType.read(buffer));
                }
                case 3: {
                    return new ObjectFieldType(isFinal);
                }
            }
            throw new IllegalStateException(String.format("Unsupported type code %s", typecode));
        }
    }

    public static class CollectionFieldType
    extends FieldType {
        private final FieldType elementType;

        public CollectionFieldType(boolean isFinal, FieldType elementType) {
            super(isFinal);
            this.elementType = elementType;
        }

        public FieldType getElementType() {
            return this.elementType;
        }

        @Override
        public TypeToken<?> toTypeToken(ClassResolver classResolver) {
            return TypeUtils.collectionOf(this.elementType.toTypeToken(classResolver));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollectionFieldType that = (CollectionFieldType)o;
            return Objects.equals(this.elementType, that.elementType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.elementType);
        }

        public String toString() {
            return "CollectionFieldType{elementType=" + this.elementType + ", isFinal=" + this.isFinal() + '}';
        }
    }

    public static class MapFieldType
    extends FieldType {
        private final FieldType keyType;
        private final FieldType valueType;

        public MapFieldType(boolean isFinal, FieldType keyType, FieldType valueType) {
            super(isFinal);
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public FieldType getKeyType() {
            return this.keyType;
        }

        public FieldType getValueType() {
            return this.valueType;
        }

        @Override
        public TypeToken<?> toTypeToken(ClassResolver classResolver) {
            return TypeUtils.mapOf(this.keyType.toTypeToken(classResolver), this.valueType.toTypeToken(classResolver));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MapFieldType that = (MapFieldType)o;
            return Objects.equals(this.keyType, that.keyType) && Objects.equals(this.valueType, that.valueType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.keyType, this.valueType);
        }

        public String toString() {
            return "MapFieldType{keyType=" + this.keyType + ", valueType=" + this.valueType + ", isFinal=" + this.isFinal() + '}';
        }
    }

    public static class RegisteredFieldType
    extends FieldType {
        private final short classId;

        public RegisteredFieldType(boolean isFinal, short classId) {
            super(isFinal);
            this.classId = classId;
        }

        public short getClassId() {
            return this.classId;
        }

        @Override
        public TypeToken<?> toTypeToken(ClassResolver classResolver) {
            return TypeToken.of(classResolver.getRegisteredClass(this.classId));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegisteredFieldType that = (RegisteredFieldType)o;
            return this.classId == that.classId;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.classId);
        }

        public String toString() {
            return "RegisteredFieldType{isFinal=" + this.isFinal() + ", classId=" + this.classId + '}';
        }
    }

    public static class ObjectFieldType
    extends FieldType {
        public ObjectFieldType(boolean isFinal) {
            super(isFinal);
        }

        @Override
        public TypeToken<?> toTypeToken(ClassResolver classResolver) {
            return this.isFinal() ? TypeToken.of(FinalObjectTypeStub.class) : TypeToken.of(Object.class);
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

