/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.internal;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.com.google.common.base.Stopwatch;
import shade.polaris.io.grpc.InternalServiceProviders;
import shade.polaris.io.grpc.NameResolver;
import shade.polaris.io.grpc.NameResolverProvider;
import shade.polaris.io.grpc.internal.DnsNameResolver;
import shade.polaris.io.grpc.internal.GrpcUtil;

public final class DnsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "dns";

    @Override
    public DnsNameResolver newNameResolver(URI targetUri, NameResolver.Args args2) {
        if (SCHEME.equals(targetUri.getScheme())) {
            String targetPath = Preconditions.checkNotNull(targetUri.getPath(), "targetPath");
            Preconditions.checkArgument(targetPath.startsWith("/"), "the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new DnsNameResolver(targetUri.getAuthority(), name, args2, GrpcUtil.SHARED_CHANNEL_EXECUTOR, Stopwatch.createUnstarted(), InternalServiceProviders.isAndroid(this.getClass().getClassLoader()));
        }
        return null;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    public int priority() {
        return 5;
    }

    @Override
    protected Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }
}

