/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.configfilefilter.util;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtil {
    public static byte[] generateAesKey() {
        KeyGenerator keyGenerator;
        try {
            keyGenerator = KeyGenerator.getInstance("AES");
        }
        catch (NoSuchAlgorithmException e) {
            throw new PolarisException(ErrorCode.AES_KEY_GENERATE_ERROR, e.getMessage());
        }
        SecureRandom secureRandom = new SecureRandom();
        keyGenerator.init(128, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey.getEncoded();
    }

    public static String encrypt(String content, byte[] password) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            byte[] iv = new byte[cipher.getBlockSize()];
            System.arraycopy(password, 0, iv, 0, cipher.getBlockSize());
            cipher.init(1, (Key)new SecretKeySpec(password, "AES"), new IvParameterSpec(iv));
            byte[] bytes = cipher.doFinal(content.getBytes());
            return Base64.getEncoder().encodeToString(bytes);
        }
        catch (Exception e) {
            throw new PolarisException(ErrorCode.AES_ENCRYPT_ERROR, e.getMessage(), e);
        }
    }

    public static String decrypt(String content, byte[] password) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            byte[] iv = new byte[cipher.getBlockSize()];
            System.arraycopy(password, 0, iv, 0, cipher.getBlockSize());
            cipher.init(2, (Key)new SecretKeySpec(password, "AES"), new IvParameterSpec(iv));
            byte[] paddingPlaintext = cipher.doFinal(Base64.getDecoder().decode(content));
            return new String(paddingPlaintext);
        }
        catch (Exception e) {
            throw new PolarisException(ErrorCode.AES_DECRYPT_ERROR, e.getMessage(), e);
        }
    }

    static {
        Security.addProvider(new BouncyCastleProvider());
    }
}

