/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.assembly.api.pojo;

import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.assembly.api.pojo.AttachmentBaseEntity;
import com.tencent.polaris.assembly.api.pojo.Capability;
import java.util.HashMap;
import java.util.Map;

public class BeforeResponse
extends AttachmentBaseEntity {
    private final RetStatus retStatus;
    private final Instance selectedInstance;
    private final Map<Capability, Object> capabilityResponses = new HashMap<Capability, Object>();

    public BeforeResponse(RetStatus retStatus, Instance selectedInstance, Map<Capability, Object> capabilityResponses) {
        this.retStatus = retStatus;
        this.selectedInstance = selectedInstance;
        if (!CollectionUtils.isEmpty(capabilityResponses)) {
            this.capabilityResponses.putAll(capabilityResponses);
        }
    }

    public RetStatus getRetStatus() {
        return this.retStatus;
    }

    public Instance getSelectedInstance() {
        return this.selectedInstance;
    }

    public <T> T getCapabilityResponse(Capability capability) {
        if (this.capabilityResponses.containsKey((Object)capability)) {
            return (T)this.capabilityResponses.get((Object)capability);
        }
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private RetStatus retStatus;
        private final Map<Capability, Object> capabilityResponses = new HashMap<Capability, Object>();
        private Instance selectedInstance;

        public Builder setRetStatus(RetStatus retStatus) {
            this.retStatus = retStatus;
            return this;
        }

        public Builder putCapabilityResponse(Capability capability, Object response) {
            this.capabilityResponses.put(capability, response);
            return this;
        }

        public Builder setSelectedInstance(Instance selectedInstance) {
            this.selectedInstance = selectedInstance;
            return this;
        }

        public BeforeResponse build() {
            return new BeforeResponse(this.retStatus, this.selectedInstance, this.capabilityResponses);
        }
    }
}

