/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc.protocol;

import com.alipay.remoting.AsyncContext;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.RemotingContext;
import com.alipay.remoting.ResponseStatus;
import com.alipay.remoting.rpc.protocol.RpcRequestCommand;
import com.alipay.remoting.rpc.protocol.RpcRequestProcessor;
import java.util.concurrent.atomic.AtomicBoolean;

public class RpcAsyncContext
implements AsyncContext {
    private RemotingContext ctx;
    private RpcRequestCommand cmd;
    private RpcRequestProcessor processor;
    private AtomicBoolean isResponseSentAlready = new AtomicBoolean();

    public RpcAsyncContext(RemotingContext ctx, RpcRequestCommand cmd, RpcRequestProcessor processor) {
        this.ctx = ctx;
        this.cmd = cmd;
        this.processor = processor;
    }

    @Override
    public void sendResponse(Object responseObject) {
        if (!this.isResponseSentAlready.compareAndSet(false, true)) {
            throw new IllegalStateException("Should not send rpc response repeatedly!");
        }
        this.processor.sendResponseIfNecessary(this.ctx, this.cmd.getType(), (RemotingCommand)this.processor.getCommandFactory().createResponse(responseObject, this.cmd));
    }

    @Override
    public void sendException(Throwable ex) {
        if (!this.isResponseSentAlready.compareAndSet(false, true)) {
            throw new IllegalStateException("Should not send rpc response repeatedly!");
        }
        this.processor.sendResponseIfNecessary(this.ctx, this.cmd.getType(), (RemotingCommand)this.processor.getCommandFactory().createExceptionResponse(this.cmd.getId(), ResponseStatus.SERVER_EXCEPTION, ex));
    }
}

