/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter.tps;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

class StatItem {
    private final String name;
    private final AtomicLong lastResetTime;
    private final long interval;
    private final AtomicInteger token;
    private final int rate;

    StatItem(String name, int rate, long interval) {
        this.name = name;
        this.rate = rate;
        this.interval = interval;
        this.lastResetTime = new AtomicLong(System.currentTimeMillis());
        this.token = new AtomicInteger(rate);
    }

    public boolean isAllowable() {
        long now = System.currentTimeMillis();
        if (now > this.lastResetTime.get() + this.interval) {
            this.token.set(this.rate);
            this.lastResetTime.set(now);
        }
        return this.token.decrementAndGet() >= 0;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getRate() {
        return this.rate;
    }

    long getLastResetTime() {
        return this.lastResetTime.get();
    }

    int getToken() {
        return this.token.get();
    }

    public String toString() {
        return "StatItem [name=" + this.name + ", rate = " + this.rate + ", interval = " + this.interval + ']';
    }
}

