/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.filter;

import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.rpc.HeaderFilter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.RpcInvocation;
import org.apache.dubbo.rpc.support.RpcUtils;

@Activate
public class TokenHeaderFilter
implements HeaderFilter {
    @Override
    public RpcInvocation invoke(Invoker<?> invoker, RpcInvocation invocation) throws RpcException {
        String token = invoker.getUrl().getParameter("token");
        if (ConfigUtils.isNotEmpty(token)) {
            Class<?> serviceType = invoker.getInterface();
            String remoteToken = (String)invocation.getObjectAttachmentWithoutConvert("token");
            if (!token.equals(remoteToken)) {
                throw new RpcException(4, "Forbid invoke remote service " + serviceType + " method " + RpcUtils.getMethodName(invocation) + "() from consumer " + RpcContext.getServiceContext().getRemoteHost() + " to provider " + RpcContext.getServiceContext().getLocalHost() + ", consumer incorrect token is " + remoteToken);
            }
        }
        return invocation;
    }
}

