/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.util;

import java.util.Collections;
import java.util.Set;
import org.apache.dubbo.common.utils.AllowClassNotifyListener;
import org.apache.dubbo.common.utils.SerializeCheckStatus;
import org.apache.dubbo.common.utils.SerializeSecurityManager;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class SerializeCheckUtils
implements AllowClassNotifyListener {
    private final SerializeSecurityManager manager;
    private volatile Set<String> allowedList = Collections.emptySet();
    private volatile Set<String> disAllowedList = Collections.emptySet();
    private volatile SerializeCheckStatus status = AllowClassNotifyListener.DEFAULT_STATUS;
    private volatile boolean checkSerializable = true;

    public SerializeCheckUtils(FrameworkModel frameworkModel) {
        this.manager = frameworkModel.getBeanFactory().getOrRegisterBean(SerializeSecurityManager.class);
        this.manager.registerListener(this);
    }

    @Override
    public void notifyPrefix(Set<String> allowedList, Set<String> disAllowedList) {
        this.allowedList = allowedList;
        this.disAllowedList = disAllowedList;
    }

    @Override
    public void notifyCheckStatus(SerializeCheckStatus status) {
        this.status = status;
    }

    @Override
    public void notifyCheckSerializable(boolean checkSerializable) {
        this.checkSerializable = checkSerializable;
    }

    public Set<String> getAllowedList() {
        return this.allowedList;
    }

    public Set<String> getDisAllowedList() {
        return this.disAllowedList;
    }

    public SerializeCheckStatus getStatus() {
        return this.status;
    }

    public boolean isCheckSerializable() {
        return this.checkSerializable;
    }

    public Set<String> getWarnedClasses() {
        return this.manager.getWarnedClasses();
    }
}

