/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metrics.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.metrics.collector.MetricsCollector;
import org.apache.dubbo.metrics.model.MetricsCategory;
import org.apache.dubbo.metrics.model.sample.GaugeMetricSample;
import org.apache.dubbo.metrics.model.sample.MetricSample;
import org.apache.dubbo.metrics.service.MetricsEntity;
import org.apache.dubbo.metrics.service.MetricsService;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class DefaultMetricsService
implements MetricsService {
    protected final List<MetricsCollector> collectors = new ArrayList<MetricsCollector>();

    public DefaultMetricsService(ApplicationModel applicationModel) {
        this.collectors.addAll(applicationModel.getBeanFactory().getBeansOfType(MetricsCollector.class));
    }

    @Override
    public Map<MetricsCategory, List<MetricsEntity>> getMetricsByCategories(List<MetricsCategory> categories) {
        return this.getMetricsByCategories(null, categories);
    }

    @Override
    public Map<MetricsCategory, List<MetricsEntity>> getMetricsByCategories(String serviceUniqueName, List<MetricsCategory> categories) {
        return this.getMetricsByCategories(serviceUniqueName, null, null, categories);
    }

    @Override
    public Map<MetricsCategory, List<MetricsEntity>> getMetricsByCategories(String serviceUniqueName, String methodName, Class<?>[] parameterTypes, List<MetricsCategory> categories) {
        HashMap<MetricsCategory, List<MetricsEntity>> result = new HashMap<MetricsCategory, List<MetricsEntity>>();
        for (MetricsCollector collector : this.collectors) {
            List<MetricSample> samples = collector.collect();
            for (MetricSample sample : samples) {
                if (!categories.contains((Object)sample.getCategory())) continue;
                List entities = result.computeIfAbsent(sample.getCategory(), k -> new ArrayList());
                entities.add(this.sampleToEntity(sample));
            }
        }
        return result;
    }

    private MetricsEntity sampleToEntity(MetricSample sample) {
        MetricsEntity entity = new MetricsEntity();
        entity.setName(sample.getName());
        entity.setTags(sample.getTags());
        entity.setCategory(sample.getCategory());
        switch (sample.getType()) {
            case GAUGE: {
                GaugeMetricSample gaugeSample = (GaugeMetricSample)sample;
                entity.setValue(gaugeSample.getApply().applyAsDouble(gaugeSample.getValue()));
                break;
            }
        }
        return entity;
    }
}

