/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config.spring.util;

import java.lang.reflect.Method;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.context.ApplicationContext;

public class LockUtils {
    private static final String DUBBO_SINGLETON_MUTEX_KEY = "DUBBO_SINGLETON_MUTEX";

    public static synchronized Object getSingletonMutex(ApplicationContext applicationContext) {
        DefaultSingletonBeanRegistry autowireCapableBeanFactory = (DefaultSingletonBeanRegistry)applicationContext.getAutowireCapableBeanFactory();
        try {
            return autowireCapableBeanFactory.getSingletonMutex();
        }
        catch (Throwable t1) {
            try {
                Method method = DefaultSingletonBeanRegistry.class.getDeclaredMethod("getSingletonMutex", new Class[0]);
                method.setAccessible(true);
                return method.invoke((Object)autowireCapableBeanFactory, new Object[0]);
            }
            catch (Throwable t2) {
                if (!autowireCapableBeanFactory.containsSingleton(DUBBO_SINGLETON_MUTEX_KEY)) {
                    autowireCapableBeanFactory.registerSingleton(DUBBO_SINGLETON_MUTEX_KEY, new Object());
                }
                return autowireCapableBeanFactory.getSingleton(DUBBO_SINGLETON_MUTEX_KEY);
            }
        }
    }
}

