/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.RepositorySettingsBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GcsRepositorySettings
extends RepositorySettingsBase {
    private final String bucket;
    @Nullable
    private final String client;
    @Nullable
    private final String basePath;
    @Nullable
    private final Boolean readonly;
    @Nullable
    private final String applicationName;
    public static final JsonpDeserializer<GcsRepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GcsRepositorySettings::setupGcsRepositorySettingsDeserializer);

    private GcsRepositorySettings(Builder builder) {
        super(builder);
        this.bucket = ApiTypeHelper.requireNonNull(builder.bucket, this, "bucket");
        this.client = builder.client;
        this.basePath = builder.basePath;
        this.readonly = builder.readonly;
        this.applicationName = builder.applicationName;
    }

    public static GcsRepositorySettings of(Function<Builder, ObjectBuilder<GcsRepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String bucket() {
        return this.bucket;
    }

    @Nullable
    public final String client() {
        return this.client;
    }

    @Nullable
    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final Boolean readonly() {
        return this.readonly;
    }

    @Nullable
    public final String applicationName() {
        return this.applicationName;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("bucket");
        generator.write(this.bucket);
        if (this.client != null) {
            generator.writeKey("client");
            generator.write(this.client);
        }
        if (this.basePath != null) {
            generator.writeKey("base_path");
            generator.write(this.basePath);
        }
        if (this.readonly != null) {
            generator.writeKey("readonly");
            generator.write(this.readonly.booleanValue());
        }
        if (this.applicationName != null) {
            generator.writeKey("application_name");
            generator.write(this.applicationName);
        }
    }

    protected static void setupGcsRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        RepositorySettingsBase.setupRepositorySettingsBaseDeserializer(op);
        op.add(Builder::bucket, JsonpDeserializer.stringDeserializer(), "bucket");
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::readonly, JsonpDeserializer.booleanDeserializer(), "readonly");
        op.add(Builder::applicationName, JsonpDeserializer.stringDeserializer(), "application_name");
    }

    public static class Builder
    extends RepositorySettingsBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GcsRepositorySettings> {
        private String bucket;
        @Nullable
        private String client;
        @Nullable
        private String basePath;
        @Nullable
        private Boolean readonly;
        @Nullable
        private String applicationName;

        public final Builder bucket(String value) {
            this.bucket = value;
            return this;
        }

        public final Builder client(@Nullable String value) {
            this.client = value;
            return this;
        }

        public final Builder basePath(@Nullable String value) {
            this.basePath = value;
            return this;
        }

        public final Builder readonly(@Nullable Boolean value) {
            this.readonly = value;
            return this;
        }

        public final Builder applicationName(@Nullable String value) {
            this.applicationName = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GcsRepositorySettings build() {
            this._checkSingleUse();
            return new GcsRepositorySettings(this);
        }
    }
}

