/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final List<String> formats;
    @Nullable
    private final String locale;
    @Nullable
    private final String targetField;
    @Nullable
    private final String timezone;
    public static final JsonpDeserializer<DateProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateProcessor::setupDateProcessorDeserializer);

    private DateProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.formats = ApiTypeHelper.unmodifiableRequired(builder.formats, (Object)this, "formats");
        this.locale = builder.locale;
        this.targetField = builder.targetField;
        this.timezone = builder.timezone;
    }

    public static DateProcessor of(Function<Builder, ObjectBuilder<DateProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Date;
    }

    public final String field() {
        return this.field;
    }

    public final List<String> formats() {
        return this.formats;
    }

    @Nullable
    public final String locale() {
        return this.locale;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String timezone() {
        return this.timezone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.formats)) {
            generator.writeKey("formats");
            generator.writeStartArray();
            for (String item0 : this.formats) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.locale != null) {
            generator.writeKey("locale");
            generator.write(this.locale);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.timezone != null) {
            generator.writeKey("timezone");
            generator.write(this.timezone);
        }
    }

    protected static void setupDateProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::formats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "formats");
        op.add(Builder::locale, JsonpDeserializer.stringDeserializer(), "locale");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::timezone, JsonpDeserializer.stringDeserializer(), "timezone");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateProcessor> {
        private String field;
        private List<String> formats;
        @Nullable
        private String locale;
        @Nullable
        private String targetField;
        @Nullable
        private String timezone;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder formats(List<String> list) {
            this.formats = Builder._listAddAll(this.formats, list);
            return this;
        }

        public final Builder formats(String value, String ... values) {
            this.formats = Builder._listAdd(this.formats, value, values);
            return this;
        }

        public final Builder locale(@Nullable String value) {
            this.locale = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder timezone(@Nullable String value) {
            this.timezone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateProcessor build() {
            this._checkSingleUse();
            return new DateProcessor(this);
        }
    }
}

