/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.common.sampler;

import java.util.BitSet;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.logging.common.sampler.Sampler;
import org.springframework.web.server.ServerWebExchange;

public class CountSampler
implements Sampler {
    private final AtomicInteger counter = new AtomicInteger();
    private final BitSet sampleDecisions;

    public CountSampler(float probability) {
        int percent = (int)(probability * 100.0f);
        this.sampleDecisions = this.genRandomBitSet(100, percent);
    }

    @Override
    public boolean isSampled(ServerWebExchange exchange, SelectorData selectorData) {
        return this.sampleDecisions.get(this.mod(this.counter.getAndIncrement()));
    }

    private int mod(int dividend) {
        int result = dividend % 100;
        return result >= 0 ? result : 100 + result;
    }

    private BitSet genRandomBitSet(int size, int cardinality) {
        int i;
        BitSet result = new BitSet(size);
        int[] chosen = new int[cardinality];
        for (i = 0; i < cardinality; ++i) {
            chosen[i] = i;
            result.set(i);
        }
        Random random = new Random();
        while (i < size) {
            int j = random.nextInt(i + 1);
            if (j < cardinality) {
                result.clear(chosen[j]);
                result.set(i);
                chosen[j] = i;
            }
            ++i;
        }
        return result;
    }

    public static Sampler create(String probability) {
        if (StringUtils.isBlank((CharSequence)probability)) {
            return ALWAYS_SAMPLE;
        }
        if ("0".equals(probability)) {
            return NEVER_SAMPLE;
        }
        if ("1".equals(probability) || "1.0".equals(probability) || "1.0.0".equals(probability)) {
            return ALWAYS_SAMPLE;
        }
        float parseProbability = NumberUtils.toFloat((String)probability, (float)1.0f);
        if (parseProbability < 0.01f || parseProbability > 1.0f) {
            throw new IllegalArgumentException("probability should be between 0.01 and 1: was " + probability);
        }
        return new CountSampler(parseProbability);
    }
}

