/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.log.jul;

import com.alibaba.csp.sentinel.log.Logger;
import com.alibaba.csp.sentinel.log.jul.BaseJulLogger;
import com.alibaba.csp.sentinel.log.jul.Level;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.logging.Handler;

public class JavaLoggingAdapter
extends BaseJulLogger
implements Logger {
    private final String loggerName;
    private final String fileNamePattern;
    private final java.util.logging.Logger julLogger;
    private final Handler logHandler;

    public JavaLoggingAdapter(String loggerName, String fileNamePattern) {
        AssertUtil.assertNotBlank(loggerName, "loggerName cannot be blank");
        AssertUtil.assertNotBlank(fileNamePattern, "fileNamePattern cannot be blank");
        this.loggerName = loggerName;
        this.fileNamePattern = fileNamePattern;
        this.julLogger = java.util.logging.Logger.getLogger(loggerName);
        this.logHandler = this.makeLoggingHandler(fileNamePattern, this.julLogger);
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.INFO, format, arguments);
    }

    @Override
    public void info(String msg, Throwable e) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.INFO, msg, e);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.WARNING, format, arguments);
    }

    @Override
    public void warn(String msg, Throwable e) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.WARNING, msg, e);
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.TRACE, format, arguments);
    }

    @Override
    public void trace(String msg, Throwable e) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.TRACE, msg, e);
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.DEBUG, format, arguments);
    }

    @Override
    public void debug(String msg, Throwable e) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.DEBUG, msg, e);
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.ERROR, format, arguments);
    }

    @Override
    public void error(String msg, Throwable e) {
        this.log(this.julLogger, this.logHandler, (java.util.logging.Level)Level.ERROR, msg, e);
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public String getFileNamePattern() {
        return this.fileNamePattern;
    }
}

