/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.RemotingCommand;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.util.ConnectionUtil;
import com.alipay.remoting.util.StringUtils;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.ConcurrentHashMap;

public class RemotingContext
implements Cloneable {
    private ChannelHandlerContext channelContext;
    private boolean serverSide = false;
    private boolean timeoutDiscard = true;
    private long arriveTimestamp;
    private int timeout;
    private int rpcCommandType;
    private ConcurrentHashMap<String, UserProcessor<?>> userProcessors;
    private InvokeContext invokeContext;

    public RemotingContext(ChannelHandlerContext ctx) {
        this.channelContext = ctx;
    }

    public RemotingContext(ChannelHandlerContext ctx, boolean serverSide) {
        this.channelContext = ctx;
        this.serverSide = serverSide;
    }

    public RemotingContext(ChannelHandlerContext ctx, boolean serverSide, ConcurrentHashMap<String, UserProcessor<?>> userProcessors) {
        this.channelContext = ctx;
        this.serverSide = serverSide;
        this.userProcessors = userProcessors;
    }

    public RemotingContext(ChannelHandlerContext ctx, InvokeContext invokeContext, boolean serverSide, ConcurrentHashMap<String, UserProcessor<?>> userProcessors) {
        this.channelContext = ctx;
        this.serverSide = serverSide;
        this.userProcessors = userProcessors;
        this.invokeContext = invokeContext;
    }

    public ChannelFuture writeAndFlush(RemotingCommand msg) {
        return this.channelContext.writeAndFlush((Object)msg);
    }

    public ChannelFuture write(RemotingCommand msg) {
        return this.channelContext.write((Object)msg);
    }

    public void flush() {
        this.channelContext.flush();
    }

    public boolean isRequestTimeout() {
        return this.timeout > 0 && this.rpcCommandType != 2 && System.currentTimeMillis() - this.arriveTimestamp > (long)this.timeout;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public UserProcessor<?> getUserProcessor(String className) {
        return StringUtils.isBlank(className) ? null : this.userProcessors.get(className);
    }

    public Connection getConnection() {
        return ConnectionUtil.getConnectionFromChannel(this.channelContext.channel());
    }

    public ChannelHandlerContext getChannelContext() {
        return this.channelContext;
    }

    public void setChannelContext(ChannelHandlerContext ctx) {
        this.channelContext = ctx;
    }

    public InvokeContext getInvokeContext() {
        return this.invokeContext;
    }

    public void setArriveTimestamp(long arriveTimestamp) {
        this.arriveTimestamp = arriveTimestamp;
    }

    public long getArriveTimestamp() {
        return this.arriveTimestamp;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setRpcCommandType(int rpcCommandType) {
        this.rpcCommandType = rpcCommandType;
    }

    public boolean isTimeoutDiscard() {
        return this.timeoutDiscard;
    }

    public RemotingContext setTimeoutDiscard(boolean failFastEnabled) {
        this.timeoutDiscard = failFastEnabled;
        return this;
    }

    public RemotingContext clone() {
        return new RemotingContext(this.channelContext, new InvokeContext(), this.serverSide, this.userProcessors);
    }
}

