/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.common;

import com.tencentcloudapi.cls.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.producer.common.ExpiredBatches;
import com.tencentcloudapi.cls.producer.common.LogAccumulator;
import com.tencentcloudapi.cls.producer.common.LogThread;
import com.tencentcloudapi.cls.producer.common.ProducerBatch;
import com.tencentcloudapi.cls.producer.common.RetryQueue;
import com.tencentcloudapi.cls.producer.common.SendProducerBatchTask;
import com.tencentcloudapi.cls.producer.common.SendThreadPool;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerSendBatchTask
extends LogThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimerSendBatchTask.class);
    private final AsyncProducerConfig producerConfig;
    private final LogAccumulator accumulator;
    private final RetryQueue retryQueue;
    private final BlockingQueue<ProducerBatch> successQueue;
    private final BlockingQueue<ProducerBatch> failureQueue;
    private final SendThreadPool sendThreadPool;
    private final AtomicInteger batchCount;
    private volatile boolean closed;

    public TimerSendBatchTask(String name, boolean daemon, AsyncProducerConfig producerConfig, LogAccumulator accumulator, RetryQueue retryQueue, BlockingQueue<ProducerBatch> successQueue, BlockingQueue<ProducerBatch> failureQueue, SendThreadPool sendThreadPool, AtomicInteger batchCount) {
        super(name, daemon);
        this.producerConfig = producerConfig;
        this.accumulator = accumulator;
        this.retryQueue = retryQueue;
        this.successQueue = successQueue;
        this.failureQueue = failureQueue;
        this.sendThreadPool = sendThreadPool;
        this.batchCount = batchCount;
        this.closed = false;
    }

    public void close() {
        this.closed = true;
        this.interrupt();
    }

    @Override
    public void run() {
        this.loopCheckSendBatches();
        List<ProducerBatch> incompleteBatches = this.incompleteBatches();
        this.submitIncompleteBatches(incompleteBatches);
    }

    private void loopCheckSendBatches() {
        while (!this.closed) {
            try {
                this.doSendBatches();
            }
            catch (Exception e) {
                LOGGER.error("Uncaught exception in timer batch send task, e=", (Throwable)e);
            }
        }
    }

    private void doSendBatches() {
        ExpiredBatches expiredBatches = this.accumulator.expiredBatches();
        for (ProducerBatch b : expiredBatches.getBatches()) {
            this.sendThreadPool.submit(this.createSendProducerBatchTask(b));
        }
        List<ProducerBatch> expiredRetryBatches = this.retryQueue.expiredBatches(expiredBatches.getRemainingMs());
        for (ProducerBatch b : expiredRetryBatches) {
            this.sendThreadPool.submit(this.createSendProducerBatchTask(b));
        }
    }

    private SendProducerBatchTask createSendProducerBatchTask(ProducerBatch batch) {
        return new SendProducerBatchTask(batch, this.producerConfig, this.retryQueue, this.successQueue, this.failureQueue, this.batchCount);
    }

    private List<ProducerBatch> incompleteBatches() {
        List<ProducerBatch> incompleteBatches = this.accumulator.remainingBatches();
        incompleteBatches.addAll(this.retryQueue.remainingBatches());
        return incompleteBatches;
    }

    private void submitIncompleteBatches(List<ProducerBatch> incompleteBatches) {
        for (ProducerBatch b : incompleteBatches) {
            this.sendThreadPool.submit(this.createSendProducerBatchTask(b));
        }
    }
}

