/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer;

import com.tencentcloudapi.cls.producer.common.Constants;
import com.tencentcloudapi.cls.producer.util.Args;
import com.tencentcloudapi.cls.producer.util.NetworkUtils;
import javax.annotation.Nonnull;

public class AsyncProducerConfig {
    private String httpType;
    private String hostName;
    private String secretId;
    private String secretKey;
    private String secretToken;
    private String sourceIp;
    private String topicId;
    private int totalSizeInBytes = 0x6400000;
    private long maxBlockMs = 60000L;
    private int sendThreadCount = Constants.DEFAULT_SEND_THREAD_COUNT;
    private int batchSizeThresholdInBytes = 524288;
    private int batchCountThreshold = 4096;
    private int lingerMs = 2000;
    private int retries = 10;
    private int maxReservedAttempts = 11;
    private long baseRetryBackoffMs = 100L;
    private long maxRetryBackoffMs = 50000L;

    public AsyncProducerConfig(@Nonnull String endpoint, @Nonnull String secretId, @Nonnull String secretKey, String sourceIp) {
        Args.notNullOrEmpty(endpoint, "endpoint");
        Args.notNullOrEmpty(secretId, "secretId");
        Args.notNullOrEmpty(secretKey, "secretKey");
        if (endpoint.startsWith("http://")) {
            this.hostName = endpoint.substring(7);
            this.httpType = "http://";
        } else if (endpoint.startsWith("https://")) {
            this.hostName = endpoint.substring(8);
            this.httpType = "https://";
        } else {
            this.hostName = endpoint;
            this.httpType = "http://";
        }
        while (this.hostName.endsWith("/")) {
            this.hostName = this.hostName.substring(0, this.hostName.length() - 1);
        }
        if (NetworkUtils.isIPAddr(this.hostName)) {
            throw new IllegalArgumentException("EndpointInvalid", new Exception("The ip address is not supported"));
        }
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.sourceIp = sourceIp;
        if (sourceIp == null || sourceIp.isEmpty()) {
            this.sourceIp = NetworkUtils.getLocalMachineIP();
        }
    }

    public AsyncProducerConfig(@Nonnull String endpoint, @Nonnull String secretId, @Nonnull String secretKey, String sourceIp, String secretToken) {
        Args.notNullOrEmpty(endpoint, "endpoint");
        Args.notNullOrEmpty(secretId, "secretId");
        Args.notNullOrEmpty(secretKey, "secretKey");
        if (endpoint.startsWith("http://")) {
            this.hostName = endpoint.substring(7);
            this.httpType = "http://";
        } else if (endpoint.startsWith("https://")) {
            this.hostName = endpoint.substring(8);
            this.httpType = "https://";
        } else {
            this.hostName = endpoint;
            this.httpType = "http://";
        }
        while (this.hostName.endsWith("/")) {
            this.hostName = this.hostName.substring(0, this.hostName.length() - 1);
        }
        if (NetworkUtils.isIPAddr(this.hostName)) {
            throw new IllegalArgumentException("EndpointInvalid", new Exception("The ip address is not supported"));
        }
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.sourceIp = sourceIp;
        if (sourceIp == null || sourceIp.isEmpty()) {
            this.sourceIp = NetworkUtils.getLocalMachineIP();
        }
        this.secretToken = secretToken;
        if (null == this.secretToken || this.secretToken.isEmpty()) {
            this.secretToken = "";
        }
    }

    public String getHttpType() {
        return this.httpType;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSecretToken() {
        return this.secretToken;
    }

    public void resetSecurityToken(String accessKeyId, String accessKeySecret, String securityToken) {
        Args.notNullOrEmpty(accessKeyId, "secretId");
        Args.notNullOrEmpty(accessKeySecret, "secretKey");
        Args.notNullOrEmpty(securityToken, "secretToken");
        this.secretId = accessKeyId;
        this.secretKey = accessKeySecret;
        this.secretToken = securityToken;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public int getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(int totalSizeInBytes) {
        if (totalSizeInBytes <= 0) {
            throw new IllegalArgumentException("totalSizeInBytes must be greater than 0, got " + totalSizeInBytes);
        }
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public long getMaxBlockMs() {
        return this.maxBlockMs;
    }

    public void setMaxBlockMs(long maxBlockMs) {
        this.maxBlockMs = maxBlockMs;
    }

    public int getSendThreadCount() {
        return this.sendThreadCount;
    }

    public void setSendThreadCount(int sendThreadCount) {
        if (sendThreadCount <= 0) {
            throw new IllegalArgumentException("sendThreadCount must be greater than 0, got " + sendThreadCount);
        }
        this.sendThreadCount = sendThreadCount;
    }

    public int getBatchSizeThresholdInBytes() {
        return this.batchSizeThresholdInBytes;
    }

    public void setBatchSizeThresholdInBytes(int batchSizeThresholdInBytes) {
        if (batchSizeThresholdInBytes < 1 || batchSizeThresholdInBytes > 0x500000) {
            throw new IllegalArgumentException(String.format("batchSizeThresholdInBytes must be between 1 and %d, got %d", 0x500000, batchSizeThresholdInBytes));
        }
        this.batchSizeThresholdInBytes = batchSizeThresholdInBytes;
    }

    public int getBatchCountThreshold() {
        return this.batchCountThreshold;
    }

    public void setBatchCountThreshold(int batchCountThreshold) {
        if (batchCountThreshold < 1 || batchCountThreshold > 10000) {
            throw new IllegalArgumentException(String.format("batchCountThreshold must be between 1 and %d, got %d", 10000, batchCountThreshold));
        }
        this.batchCountThreshold = batchCountThreshold;
    }

    public int getLingerMs() {
        return this.lingerMs;
    }

    public void setLingerMs(int lingerMs) {
        if (lingerMs < 100) {
            throw new IllegalArgumentException(String.format("lingerMs must be greater than or equal to %d, got %d", 100, lingerMs));
        }
        this.lingerMs = lingerMs;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getMaxReservedAttempts() {
        return this.maxReservedAttempts;
    }

    public void setMaxReservedAttempts(int maxReservedAttempts) {
        if (maxReservedAttempts <= 0) {
            throw new IllegalArgumentException("maxReservedAttempts must be greater than 0, got " + maxReservedAttempts);
        }
        this.maxReservedAttempts = maxReservedAttempts;
    }

    public long getBaseRetryBackoffMs() {
        return this.baseRetryBackoffMs;
    }

    public void setBaseRetryBackoffMs(long baseRetryBackoffMs) {
        if (baseRetryBackoffMs <= 0L) {
            throw new IllegalArgumentException("baseRetryBackoffMs must be greater than 0, got " + baseRetryBackoffMs);
        }
        this.baseRetryBackoffMs = baseRetryBackoffMs;
    }

    public long getMaxRetryBackoffMs() {
        return this.maxRetryBackoffMs;
    }

    public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
        if (maxRetryBackoffMs <= 0L) {
            throw new IllegalArgumentException("maxRetryBackoffMs must be greater than 0, got " + maxRetryBackoffMs);
        }
        this.maxRetryBackoffMs = maxRetryBackoffMs;
    }
}

